package com.bxm.fossicker.activity.service.advert.filter.general;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * 热词过滤器，对ios进行转码处理
 *
 * @author liujia
 * @date 2020/01/17 10:42
 */
//@AdverFilter({SEARCH_PAGE_HOT_SEARCH_WORDS, HOME_PAGE_HOT_SEARCH_WORDS})
@Slf4j
public class HotwordFilter extends AbstractAdvertisementFilter {

    private String searchSeq = "?";

    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        log.debug("对热词进行转码处理，请求参数：{}，广告列表：{}", param, JSON.toJSONString(advertDtos));
        //已通过运用后台编码处理
        //仅对ios做转码处理
//        if (null != param.getAdvertParam() &&
//                PlatformEnum.IOS.getCode() == param.getAdvertParam().getPlatform()) {
//            advertDtos.forEach(advert -> {
//                String path = advert.getUrl();
//                if (StringUtils.contains(path, searchSeq) && !path.endsWith(searchSeq)) {
//                    String url = StringUtils.substring(path, 0, path.indexOf(searchSeq) + 1);
//                    String query = StringUtils.substring(path, path.indexOf(searchSeq) + 1);
//                    query = URLEncoder.DEFAULT.encode(query, UTF_8);
//
//                    advert.setUrl(url + query);
//                }
//            });
//        }

        return true;
    }
}
