package com.bxm.fossicker.activity.service.advert.filter.general;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.service.Taoqi365ParseUrlService;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import static java.nio.charset.StandardCharsets.UTF_8;

/**
 * 淘气365权益广告
 * 需要在配置的广告中增加签名处理，对占位符进行填充
 * @author liujia
 * @date 2020/03/10 15:09
 */
@AdverFilter
public class Taoqi365AdvertisementFilter extends AbstractAdvertisementFilter {

    private final ActivityProperties activityProperties;

    @Autowired
    Taoqi365ParseUrlService taoqi365ParseUrlService;

    /**
     * 历史路径，不要修改，如365修改了base路径，可以修改配置值：
     * {@link ActivityProperties#getTaoqi365BaseUrl()}
     */
    private final static String URL_PREFIX = "http://tq.jfshou.cn";

    @Autowired
    public Taoqi365AdvertisementFilter(ActivityProperties activityProperties) {
        this.activityProperties = activityProperties;
    }

    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        advertDtos.forEach(item -> {
            if (StringUtils.startsWithAny(item.getUrl(), URL_PREFIX, activityProperties.getTaoqi365BaseUrl())) {
                String afterParseUrl = parseUrl(item.getUrl(), param);
                //替换历史数据中的路径为配置中的根路径
                afterParseUrl = StringUtils.replace(afterParseUrl,
                        URL_PREFIX,
                        activityProperties.getTaoqi365BaseUrl());
                item.setUrl(afterParseUrl);
            }
        });
        return true;
    }

    /**
     * 解析原始url，进行路径处理
     * @param sourceUrl 运营配置的淘气权益365商品地址
     * @return 处理后的地址
     */
    private String parseUrl(String sourceUrl, AdvertisementFilterParam param) {

       return taoqi365ParseUrlService.parseUrl(sourceUrl,
               param.getAdvertParam().getUserId().toString(),
               activityProperties.getTaoqi365AgentId());
    }

}
