package com.bxm.fossicker.activity.service.advert.filter.position;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.model.enums.AdvertPositionEnum;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.base.facade.AppVersionFacadeService;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@AdverFilter(AdvertPositionEnum.HOME_PAGE_ICONS)
public class IndexIconFilter extends AbstractAdvertisementFilter {


    @Autowired
    private AppVersionFacadeService appVersionFacadeService;

    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {

//        // 提审内容控制
//        AppVersionParam appVersionParam = new AppVersionParam();
//        BeanUtils.copyProperties(param.getAdvertParam(), appVersionParam);
//        // 判断当前版本是否处于审核中-非提审状态去除为了提审添加的icon(今日推荐、热销爆款)
//        if (!appVersionFacadeService.getAuditStatus(appVersionParam)) {
//            //非提审状态去除 为了提审而添加的icon今日推荐、热销爆款)-
//            advertDtos.removeIf(p -> Objects.equals(advertConfig.getHotSearchName(), p.getTitle()));
//            advertDtos.removeIf(p -> Objects.equals(advertConfig.getTodayRecommendName(), p.getTitle()));
//        }

        // 1.3.1版本一下，过滤掉一部分的icon
        if (null != param.getAdvertParam() && StringUtils.compareVersion(param.getAdvertParam().getCurVer(), "1.3.1") < 0) {
            advertDtos.removeIf(p -> advertConfig.getFilterNames().stream().anyMatch(p1 -> p1.equals(p.getTitle())));
        }

        return true;
    }


}
