package com.bxm.fossicker.activity.service.advert.filter.position;

import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.model.constant.Constants;
import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.model.enums.AdvertPositionEnum;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.user.facade.dto.UserLoginHistoryDTO;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @authoer Gonzo
 * @date 2019-08-21 10:28
 * <p>
 * 用户未完成开启通知、填写邀请码任务，应默认显示领亲友红包、填写邀请码、开启通知、常见问题、我的收藏，
 * 完成任意一个填写邀请码或开启通知，再显示邀请好友
 */
@AdverFilter(AdvertPositionEnum.USER_PAGE_ICONS)
public class MyIconFilter extends AbstractAdvertisementFilter {

    @Autowired
    private UserInfoFacadeService infoFacadeService;

    @Autowired
    private RedisSetAdapter redisSetAdapter;


    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {

        boolean showInviteUserIcon = false;
        // 如果开启了通知
        if (Objects.equals(param.getAdvertParam().getOpenNotice(), Boolean.TRUE)) {
            // 过滤掉通知的icon
            // 这里用名字的方式，其实不可取

            advertDtos.removeIf(p -> Objects.equals(advertConfig.getOpenNoticeName(), p.getTitle()));

            showInviteUserIcon = true;
        }

        // 是否填写邀请码
        if (null != param.getAdvertParam().getUserId()) {
            if (redisSetAdapter.exists(ActivityRedisKey.NOT_SHOW_WRITE_INVITE_CODE, param.getAdvertParam().getUserId())) {
                advertDtos.removeIf(p -> Objects.equals(advertConfig.getInputInviteCodeName(), p.getTitle()));
                showInviteUserIcon = true;
            } else {
                UserInfoDto userInfoDto = param.getUserInfoDto();
                if (null != userInfoDto && null != userInfoDto.getSuperiorUserId() && 0 != userInfoDto.getSuperiorUserId()) {
                    advertDtos.removeIf(p -> Objects.equals(advertConfig.getInputInviteCodeName(), p.getTitle()));
                    showInviteUserIcon = true;
                    redisSetAdapter.add(ActivityRedisKey.NOT_SHOW_WRITE_INVITE_CODE, param.getAdvertParam().getUserId());
                } else if (null != userInfoDto) {
                    //用户是否三天登录过
                    UserLoginHistoryDTO userLoginHistoryDTO = infoFacadeService.getFirstLoginInfo(param.getAdvertParam().getUserId());
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(org.apache.commons.lang.time.DateUtils.addDays(userLoginHistoryDTO.getLastLoginTime(), Constants.DO_NOT_SHOW_DAY));
                    calendar.set(Calendar.HOUR, 23);
                    calendar.set(Calendar.MINUTE, 59);
                    calendar.set(Calendar.SECOND, 59);
                    if (DateUtils.after(new Date(), calendar.getTime())) {
                        advertDtos.removeIf(p -> Objects.equals(advertConfig.getInputInviteCodeName(), p.getTitle()));
                        showInviteUserIcon = true;
                        redisSetAdapter.add(ActivityRedisKey.NOT_SHOW_WRITE_INVITE_CODE, param.getAdvertParam().getUserId());
                    }
                }

            }

        }

        // 如果未开启通知，也未填写邀请码，则移除邀请好友icon
        if (!showInviteUserIcon) {
            advertDtos.removeIf(p -> Objects.equals(advertConfig.getInviteUserName(), p.getTitle()));
        }

        // 1.3.0版本一下，过滤掉一部分的icon
        if (StringUtils.compareVersion(param.getAdvertParam().getCurVer(), "1.3.0") < 0) {
            advertDtos.removeIf(p -> Objects.equals(advertConfig.getCustomer(), p.getTitle()));
        }
        return true;
    }


}
