package com.bxm.fossicker.activity.service.advert.impl;

import com.bxm.fossicker.activity.config.AdvertConfig;
import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.service.advert.AdvertisementFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @authoer Gonzo
 * @date 2019-08-21 10:05
 * 广告过滤基类
 */
public abstract class AbstractAdvertisementFilter implements AdvertisementFilter {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    protected AdvertConfig advertConfig;

    @Override
    public boolean filter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        if (param == null) {
            return false;
        }

        return doFilter(advertDtos, param);

    }

    /**
     * 广告过滤
     *
     * @param advertDtos 根据注解匹配的广告数据
     * @param param      请求广告的参数
     * @return 是否继续执行下一个filter，true表示继续执行下一个
     */
    protected abstract boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param);

}
