package com.bxm.fossicker.activity.service.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 百元话费碎片相关配置类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/4/13 9:31 上午
 */
@ConfigurationProperties(prefix = "activity.debris")
@Data
@Component
public class ActivityDebrisProperties {
    /**
     * 百元话费活动id
     */
    private Long chargeActivityId = 1L;

    /**
     * 话费碎片获取规则
     */
    private String chargeDebrisRule = "[\n" +
            "{\"key\":2, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":3, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":4, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":5, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":6, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":7, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":8, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":9, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":10, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":11, \"value\":{\"left\":2,\"right\":3}},\n" +
            "{\"key\":12, \"value\":{\"left\":2,\"right\":3}},\n" +
            "{\"key\":13, \"value\":{\"left\":2,\"right\":3}},\n" +
            "{\"key\":14, \"value\":{\"left\":2,\"right\":3}},\n" +
            "{\"key\":15, \"value\":{\"left\":2,\"right\":3}},\n" +
            "{\"key\":16, \"value\":{\"left\":3,\"right\":4}},\n" +
            "{\"key\":17, \"value\":{\"left\":3,\"right\":4}},\n" +
            "{\"key\":18, \"value\":{\"left\":4,\"right\":5}},\n" +
            "{\"key\":19, \"value\":{\"left\":4,\"right\":5}},\n" +
            "{\"key\":20, \"value\":{\"left\":4,\"right\":5}}\n" +
            "]";

    /**
     * 虚拟物品碎片获取规则
     */
    private String virtualDebrisRule = "[\n" +
            "{\"key\":2, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":3, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":4, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":5, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":6, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":7, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":8, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":9, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":10,\"value\":{\"left\":1,\"right\":1}},\n" +
            "\n" +
            "{\"key\":11, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":12, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":13, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":14, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":15, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":16, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":17, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":18, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":19, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":20, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":21, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":22, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":23, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":24, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":25, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":26, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":27, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":28, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":29, \"value\":{\"left\":1,\"right\":1}},\n" +
            "{\"key\":30, \"value\":{\"left\":1,\"right\":1}},\n" +
            "\n" +
            "{\"key\":31, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":32, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":33, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":34, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":35, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":36, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":37, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":38, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":39, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":40, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":41, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":42, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":43, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":44, \"value\":{\"left\":2,\"right\":5}},\n" +
            "{\"key\":45, \"value\":{\"left\":2,\"right\":5}}\n" +
            "]\n";

    /**
     * 第一次领取碎片是否增加抽奖次数
     */
    private Boolean firstReceiveAddLotteryNum = true;
}