package com.bxm.fossicker.activity.service.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * 零时活动相关配置
 * @Author: Gonzo
 * @Date 2020-02-11 18:43
 * @since 1.5.0
 */
@ConfigurationProperties(prefix = "activity.temp")
@Data
@Component
public class TempActivityProperties {

    /**
     * 每日登录奖励金币数
     * 默认300
     */
    private BigDecimal loginReward = BigDecimal.valueOf(300);

}
