package com.bxm.fossicker.activity.service.converter;

import com.bxm.fossicker.activity.model.DayRewardModel;
import com.alibaba.fastjson.JSONObject;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

import java.util.List;

/**
 * 天天领现金 配置对象转化
 */

@Configuration
@ConfigurationPropertiesBinding
public class DayRewardModelConverter implements Converter<String, List<DayRewardModel>> {
    @Override
    public List<DayRewardModel> convert(String s) {
        return JSONObject.parseArray(s, DayRewardModel.class);
    }
}