package com.bxm.fossicker.activity.service.debris;

import com.bxm.fossicker.activity.model.param.debris.ActivityExchangeParam;
import com.bxm.fossicker.activity.model.param.debris.ActivityUserPageParam;
import com.bxm.fossicker.activity.model.param.debris.ActivityUserParam;
import com.bxm.fossicker.activity.model.vo.debris.ActivityBarrageVo;
import com.bxm.fossicker.activity.model.vo.debris.ActivityListVo;
import com.bxm.fossicker.activity.model.vo.debris.MyActivityAwardVo;
import com.bxm.newidea.component.vo.Message;

import java.util.List;

/**
 * 活动碎片service接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/4/12 3:37 下午
 */
public interface ActivityDebrisService {

    /**
     * 获取奖品列表
     *
     * @param userPageParam 用户分页参数
     * @return 奖品列表
     */
    List<ActivityListVo> getActivityList(ActivityUserPageParam userPageParam);

    /**
     * 获取弹幕列表
     *
     * @return 弹幕列表信息
     */
    List<ActivityBarrageVo> getBarrageList();

    /**
     * 获取我的奖品列表
     *
     * @param userPageParam 分页参数
     * @return 我的奖品列表
     */
    List<MyActivityAwardVo> getMyAwardList(ActivityUserPageParam userPageParam);

    /**
     * 第一次领取碎片
     *
     * @param activityUserParam 入参
     * @return 领取结果
     */
    Message receiveDebris(ActivityUserParam activityUserParam);

    /**
     * 看视频领碎片
     *
     * @param activityUserParam 入参
     * @return 领取结果
     */
    Message addUserDebris(ActivityUserParam activityUserParam);

    /**
     * 兑换奖品
     *
     * @param activityExchangeParam 入参
     * @return 是否兑换成功
     */
    Message conversionDebris(ActivityExchangeParam activityExchangeParam);

    /**
     * 获取今天是否领取过话费碎片
     *
     * @param userId 用户id
     * @return 今天是否领取
     */
    Boolean getHistoryReceiveDebris(Long userId);

    /**
     * 将今天之前所有可用的期数状态修改为已过期
     */
    void clearYesterdayDebris();

    /**
     * 2.1版本   判断碎片是否触发碎片挽留弹窗
     * <p>
     * 条件：
     * 1）用户已领取过碎片，同时点击上一个正常弹窗关闭按钮（客户端自行判断）
     * 2）用户领取碎片小于等于19个
     *
     * @param userId
     */
    boolean checkPopForDebrisBaskPop(Long userId);
}