package com.bxm.fossicker.activity.service.debris;

import com.bxm.fossicker.activity.model.param.debris.ReceiveRedPacketParam;
import com.bxm.fossicker.activity.model.vo.debris.RedPacketVo;
import com.bxm.newidea.component.vo.Message;

import java.util.List;

/**
 * 活动红包Service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/5/18 9:49 上午
 */
public interface ActivityRedPacketService {

    /**
     * 获取碎片红包列表
     *
     * @param userId 用户id
     * @return 碎片红包列表
     */
    List<RedPacketVo> getDebrisRedPacketList(Long userId);

    /**
     * 领取红包
     *
     * @param receiveRedPacketParam 领取碎片红包入参
     * @return 执行结果
     */
    Message receiveRedPacket(ReceiveRedPacketParam receiveRedPacketParam);

    /**
     * 是否已经通过打卡领取过话费
     *
     * @param userId 用户id
     * @return 是否已经通过打开领取过话费
     */
    Boolean hasReceiveCharge(Long userId);


    /**
     * 增加抽奖次数（给测试用）
     *
     * @param userId 用户id
     */
    void increaseLotteryNum(Long userId);
}