package com.bxm.fossicker.activity.service.debris.cache;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * 用户观看视频个数缓存管理类
 * <p>
 * 缓存设计：
 * <p>
 * 用户每天看了多少个视频(Hash)，key(yyyyMMdd)->value(userId ->观看视频个数)
 *
 * @author wzy
 * @version 1.0
 * @date 2021/4/12 3:40 下午
 */
@Service
@AllArgsConstructor
public class UserDebrisCacheManager {

    private final RedisStringAdapter redisStringAdapter;

    /**
     * 增加用户观看视频的数量
     *
     * @param userId  用户id
     * @param phaseId 期数id
     */
    public Integer increaseWatchNum(Long userId, Long phaseId) {
        return redisStringAdapter.increment(buildWatchNumCache(userId, phaseId)).intValue();
    }

    /**
     * 删除当前期数的用户观看视频个数缓存
     */
    public void remove(Long userId, Long phaseId) {
        redisStringAdapter.remove(buildWatchNumCache(userId, phaseId));
    }

    /**
     * 构建观看视频个数缓存
     *
     * @param phaseId 期数id
     * @return 返回构建的缓存key
     */
    private KeyGenerator buildWatchNumCache(Long userId, Long phaseId) {

        return ActivityRedisKeyConstant.DEBRIS_WATCH_VIDEO_KEY.copy().appendKey(userId).appendKey(phaseId);
    }
}