package com.bxm.fossicker.activity.service.debris.cache;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * 用户抽奖次数缓存管理
 *
 * @author wzy
 * @version 1.0
 * @date 2021/5/18 10:29 上午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserLotteryCacheManager {

    private final RedisStringAdapter redisStringAdapter;

    public static final Long EXPIRED_TIME = 60L * 60L * 24L;

    /**
     * 增加用户抽奖次数
     *
     * @param userId 用户id
     * @return 用户抽奖次数
     */
    public void incrementUserLotteryNum(Long userId) {
        String currentDateStr = DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date());

        //如果不存在说明首次创建，设置过期时间24小时，并且自增1
        if (Boolean.FALSE.equals(redisStringAdapter.hasKey(buildUserLotteryNumCache(userId, currentDateStr)))) {
            redisStringAdapter.increment(buildUserLotteryNumCache(userId, currentDateStr), EXPIRED_TIME);
        } else {
            redisStringAdapter.increment(buildUserLotteryNumCache(userId, currentDateStr));
        }
    }

    /**
     * 获取用户
     *
     * @param userId 用户id
     * @return 用户的抽奖次数
     */
    public Integer getUserLotteryNum(Long userId) {
        String currentDateStr = DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date());

        Integer currentLotteryNum = redisStringAdapter.get(buildUserLotteryNumCache(userId, currentDateStr), Integer.class);

        return Objects.isNull(currentLotteryNum) ? 0 : currentLotteryNum;
    }

    /**
     * 构建用户抽奖次数缓存
     *
     * @param userId  用户id
     * @param dateStr 日期字符串
     * @return 缓存key
     */
    private KeyGenerator buildUserLotteryNumCache(Long userId, String dateStr) {
        return ActivityRedisKeyConstant.USER_DEBRIS_LOTTERY_NUM.copy().appendKey(userId).appendKey(dateStr);
    }
}