package com.bxm.fossicker.activity.service.debris.cache;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 用户总的抽奖次数（不分天）缓存管理
 *
 * @author wzy
 * @version 1.0
 * @date 2021/5/18 10:29 上午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserTotalLotteryCacheManager {

    private final RedisStringAdapter redisStringAdapter;

    /**
     * 增加用户抽奖次数
     *
     * @param userId 用户id
     * @return 用户抽奖次数
     */
    public void incrementUserLotteryNum(Long userId) {
        redisStringAdapter.increment(buildUserLotteryNumCache(userId));
    }

    /**
     * 获取用户
     *
     * @param userId 用户id
     * @return 用户的抽奖次数
     */
    public Integer getUserLotteryNum(Long userId) {
        Integer currentLotteryNum = redisStringAdapter.get(buildUserLotteryNumCache(userId), Integer.class);

        return Objects.isNull(currentLotteryNum) ? 0 : currentLotteryNum;
    }

    /**
     * 构建用户抽奖次数缓存
     *
     * @param userId 用户id
     * @return 缓存key
     */
    private KeyGenerator buildUserLotteryNumCache(Long userId) {
        return ActivityRedisKeyConstant.USER_TOTAL_DEBRIS_LOTTERY_NUM.copy().appendKey(userId);
    }
}