package com.bxm.fossicker.activity.service.dispatcher;

import com.bxm.fossicker.activity.service.ActivityAction;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 活动行为适配器
 *
 * @author xin.zhao
 */
@Component
public class ActivityActionDispatcher implements ApplicationContextAware {

    private Map<String, ActivityAction> activityActionMap;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        activityActionMap = applicationContext.getBeansOfType(ActivityAction.class);
    }

    public ActivityAction getByActivityName(String activityName) {
        return activityActionMap.get(activityName.toLowerCase());
    }
}
