package com.bxm.fossicker.activity.service.friends;

import com.bxm.fossicker.activity.model.dto.FriendsInviteInfoDTO;
import com.bxm.fossicker.activity.model.dto.FriendsInviteProgressDTO;
import com.bxm.fossicker.activity.model.dto.TotalFriendsInfoDTO;
import com.bxm.fossicker.activity.model.param.FriendsListParam;
import com.bxm.fossicker.user.model.dto.CashFlowDto;
import com.bxm.fossicker.user.model.dto.GoldFlowDto;
import com.bxm.fossicker.user.model.param.FlowPageParam;
import com.bxm.fossicker.vo.PageWarper;

import java.util.List;

public interface FriendsInfoService {
    /**
     * 获取好友总体信息
     * @param userId 用户id
     * @return 好友总体信息
     */
    TotalFriendsInfoDTO getTotalFriendsInfo(Long userId);

    /**
     * 获取好友邀请进度
     * @param userId 用户id
     * @return 好友邀请进度
     */
    FriendsInviteProgressDTO getInvitation(Long userId);

    /**
     * 分页查询好友列表
     * @param friendsListParam 请求参数
     * @return 好友列表
     */
    PageWarper<FriendsInviteInfoDTO> getFriendsList(FriendsListParam friendsListParam);

    List<GoldFlowDto> getFriendGoldFlow(FlowPageParam param);

    List<CashFlowDto> getFriendCashFlow(FlowPageParam param);
}
