package com.bxm.fossicker.activity.service.gold.strategy.impl;

import com.bxm.fossicker.activity.model.param.GoldDoubleParam;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.fossicker.activity.service.gold.strategy.AbstractDoubleGoldStrategyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 开宝箱翻倍奖励
 */
@Service(value = "doubleGoldByBoxService")
public class DoubleGoldByBoxServiceImpl extends AbstractDoubleGoldStrategyService {

    @Autowired
    private ActivityProperties activityProperties;


    @Override
    public Integer doubleGold(GoldDoubleParam goldDoubleParam) {

        String awardGoldNum = activityProperties.getBoxAwardGold();
        //向账户添加金币
        addGold(new BigDecimal(awardGoldNum), goldDoubleParam);


        return showGoldNum(Integer.valueOf(awardGoldNum), goldDoubleParam.getCurVer());
    }
}
