package com.bxm.fossicker.activity.service.gold.strategy.impl;

import com.bxm.fossicker.activity.model.param.GoldDoubleParam;
import com.bxm.fossicker.activity.service.task.TaskService;
import com.bxm.fossicker.activity.service.gold.strategy.AbstractDoubleGoldStrategyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 新人7天红包翻倍奖励
 */
@Service("doubleGoldByNewbieGoldService")
public class DoubleGoldByNewbieGoldServiceImpl extends AbstractDoubleGoldStrategyService {

    @Autowired
    private TaskService taskService;

    @Override
    public Integer doubleGold(GoldDoubleParam goldDoubleParam) {
        BigDecimal rewardNum = taskService.getDayGoldRewardToday(goldDoubleParam.getUserId());
        if (null == rewardNum) {
            return null;
        }
        //向账户添加金币
        addGold(rewardNum, goldDoubleParam);


        return showGoldNum(rewardNum.intValue(), goldDoubleParam.getCurVer());
    }

}
