package com.bxm.fossicker.activity.service.gold.strategy.impl;

import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.model.param.GoldDoubleParam;
import com.bxm.fossicker.activity.service.sign.SignService;
import com.bxm.fossicker.activity.service.gold.strategy.AbstractDoubleGoldStrategyService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 签到翻倍奖励
 */
@Service("doubleGoldBySignService")
@Slf4j
public class DoubleGoldBySignServiceImpl extends AbstractDoubleGoldStrategyService {

    @Autowired
    private SignService signService;

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public Integer doubleGold(GoldDoubleParam goldDoubleParam) {

        KeyGenerator limitKey = ActivityRedisKey.DOUBLE_GOLD_LIMIT.copy().appendKey(goldDoubleParam.getType())
                .appendKey(goldDoubleParam.getUserId()).appendKey(DateUtils.getCurrentDate());
        //触发限制条件则不增加 防脚本请求
        if (StringUtils.isNotBlank(redisStringAdapter.getString(limitKey))) {
            log.error("签到翻倍金币今日已领取,不再被领取");
            return null;
        }
        Integer signReward = signService.getSignReward(goldDoubleParam.getUserId());

        //向账户添加金币
        addGold(new BigDecimal(signReward), goldDoubleParam);
        //设置限制
        redisStringAdapter.set(limitKey, signReward,86400L);

        return showGoldNum(signReward, goldDoubleParam.getCurVer());
    }
}
