package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.config.TaskConfig;
import com.bxm.fossicker.activity.service.AccountIntegrationService;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 金币奖励内部服务调用 异步
 *
 * @author zhaoxin
 **/
@Log4j2
@Service
public class AccountIntegrationServiceImpl implements AccountIntegrationService {

    private final AccountFacadeService accountFacadeService;

    private final TaskConfig taskConfig;

    @Autowired
    public AccountIntegrationServiceImpl(AccountFacadeService accountFacadeService,
                                         TaskConfig taskConfig) {
        this.accountFacadeService = accountFacadeService;
        this.taskConfig = taskConfig;
    }

    @Override
    @Async
    public void rewardSign(Long userId, BigDecimal amount) {
        accountFacadeService.goldRebate(build(userId, UserGoldFlowTypeEnum.SIGN, amount));
    }

    @Override
    @Async
    public void rewardTask(Long userId, BigDecimal amount, Long taskId) {
        accountFacadeService.goldRebate(build(userId, UserGoldFlowTypeEnum.TASK, amount, taskId));
    }

    @Override
    @Async
    public void rewardFinishView(Long userId) {
        accountFacadeService.goldRebate(build(userId, UserGoldFlowTypeEnum.BROWSER_COMMODITY, taskConfig.getGoodsViewReward()));
    }

    @Override
    @Async
    public void rewardDayGold(Long userId, BigDecimal amount, Long relationId) {
        accountFacadeService.goldRebate(build(userId, UserGoldFlowTypeEnum.DAY_GOLD, amount, relationId));
    }

    @Override
    @Async
    public void rewardNewUserRedPacket(Long userId) {
        accountFacadeService.goldRebate(build(userId, UserGoldFlowTypeEnum.NEW_USER_RED_PACKET, taskConfig.getNewUserRedPacket()));
    }

    @Override
    @Async
    public void rewardShareView(Long userId) {
        accountFacadeService.goldRebate(build(userId, UserGoldFlowTypeEnum.SHARE_BROWSER_COMMODITY, taskConfig.getGoodsViewReward()));
    }

    private GoldRebateParam build(Long userId, UserGoldFlowTypeEnum userGoldFlowTypeEnum, BigDecimal amount) {
        return build(userId, userGoldFlowTypeEnum, amount, null);
    }

    private GoldRebateParam build(Long userId, UserGoldFlowTypeEnum userGoldFlowTypeEnum, BigDecimal amount, Long relationId) {
        GoldRebateParam accountTranParam = new GoldRebateParam();
        accountTranParam.setUserId(userId);
        accountTranParam.setUserGoldFlowType(userGoldFlowTypeEnum);
        accountTranParam.setAmount(amount);
        accountTranParam.setRelationId(relationId);
        return accountTranParam;
    }
}
