package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.domain.UserInviteRelationMapper;
import com.bxm.fossicker.activity.facade.ActivityFacadeService;
import com.bxm.fossicker.activity.facade.model.LoginRewardFacadeDTO;
import com.bxm.fossicker.activity.facade.model.TreasureBoxFacadeDTO;
import com.bxm.fossicker.activity.model.vo.TreasureBoxVO;
import com.bxm.fossicker.activity.service.TemporaryActivityService;
import com.bxm.fossicker.activity.service.TreasureBoxActivityService;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.fossicker.activity.service.debris.cache.UserLotteryCacheManager;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author Gonzo
 * @date 2019-10-15 16:23
 */
@Service
public class ActivityFacadeServiceImpl implements ActivityFacadeService {

    @Autowired
    private TreasureBoxActivityService treasureBoxActivityService;

    @Autowired
    private ActivityProperties activityProperties;

    @Resource
    private UserInviteRelationMapper userInviteRelationMapper;

    @Autowired
    private TemporaryActivityService temporaryActivityService;

    @Autowired
    private UserLotteryCacheManager userLotteryCacheManager;

    @Override
    public TreasureBoxFacadeDTO treasureBox(Long userId) {
        TreasureBoxVO treasureBoxVO = treasureBoxActivityService.treasureBox(userId);

        if (Objects.nonNull(treasureBoxVO)) {
            TreasureBoxFacadeDTO dto = new TreasureBoxFacadeDTO();
            BeanUtils.copyProperties(treasureBoxVO, dto);

            return dto;
        }

        return null;
    }

    @Override
    public Integer differInviteNum(Long userId) {
        int allNum = userInviteRelationMapper.selectFriendsNumByUserIdAndVersion(userId);
        int userRewardNum = activityProperties.getInviteUserRewardNum();
        return allNum%userRewardNum ==0 ? 0 : (userRewardNum-allNum%userRewardNum);
    }

    @Override
    public LoginRewardFacadeDTO loginRewardInfo(Long userId) {
        return temporaryActivityService.loginRewardInfo(userId);
    }


    @Override
    public Integer getUserLotteryNum(Long userId) {
        return userLotteryCacheManager.getUserLotteryNum(userId);
    }
}
