package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.model.enums.NewUserTaskEnum;
import com.bxm.fossicker.activity.service.AccountIntegrationService;
import com.bxm.fossicker.activity.service.ActivityAction;
import com.bxm.fossicker.activity.service.dispatcher.TaskActionDispatcher;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 活动_完成浏览商品
 *
 * @author xin.zhao
 */
@Service("finish_view")
@Log4j2
public class FinishViewActionImpl implements ActivityAction {

    private final AccountIntegrationService accountIntegrationService;
    private final TaskActionDispatcher taskActionDispatcher;

    @Autowired
    public FinishViewActionImpl(AccountIntegrationService accountIntegrationService,
                                TaskActionDispatcher taskActionDispatcher) {
        this.accountIntegrationService = accountIntegrationService;
        this.taskActionDispatcher = taskActionDispatcher;
    }

    @Override
    public BigDecimal reward(Long userId) {
        //  完成新手任务 浏览商品并切换
        taskActionDispatcher.getByTaskCode(NewUserTaskEnum.VIEW_GOODS.name())
                .complete(userId, NewUserTaskEnum.VIEW_GOODS.name());
        accountIntegrationService.rewardFinishView(userId);
        return null;
    }
}
