package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.service.AccountIntegrationService;
import com.bxm.fossicker.activity.service.ActivityAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 分享商品被浏览
 *
 * @author xin.zhao
 * @date 2019/12/26
 */
@Service("share_view")
public class ShareViewActionImpl implements ActivityAction {


    private final AccountIntegrationService accountIntegrationService;

    @Autowired
    public ShareViewActionImpl(AccountIntegrationService accountIntegrationService) {
        this.accountIntegrationService = accountIntegrationService;
    }

    @Override
    public BigDecimal reward(Long userId) {
        accountIntegrationService.rewardShareView(userId);
        return null;
    }
}
