package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.facade.Taoqi365ParseUrlFacadeService;
import com.bxm.fossicker.activity.service.Taoqi365ParseUrlService;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import static java.nio.charset.StandardCharsets.UTF_8;

/**
 * @Author: pf.w
 * @Date: 2020/5/28 15:23
 */
@Service
public class Taoqi365ParseUrlServiceImpl implements Taoqi365ParseUrlService,Taoqi365ParseUrlFacadeService {

    @Autowired
    ActivityProperties activityProperties;

    @Override
    public String parseUrl(String sourceUrl, String identify,String agentId) {
        if (StringUtils.isBlank(sourceUrl)) {
            return sourceUrl;
        }
        //增加用户唯一码
        if (sourceUrl.contains("?")) {
            sourceUrl += "&";
        } else {
            sourceUrl += "?";
        }
        sourceUrl += "machineCode=" + identify;

        // 代理商ID
        sourceUrl += "&agentId=" + agentId;

        //时间戳
        sourceUrl += "&timestamp=" + System.currentTimeMillis();

        //解析URL获取参数信息，计算签名
        List<NameValuePair> paramList = URLEncodedUtils.parse(StringUtils.substring(sourceUrl, sourceUrl.indexOf("?") + 1), UTF_8);

        paramList = paramList.stream().sorted(Comparator.comparing(NameValuePair::getName))
                .collect(Collectors.toList());

        StringBuilder signSource = new StringBuilder();

        for (NameValuePair nameValuePair : paramList) {
            if(StringUtils.equalsAny(nameValuePair.getName(),activityProperties.getExcludeParam())){
                continue;
            }

            signSource.append(nameValuePair.getName()).append("=").append(nameValuePair.getValue());
            signSource.append("&");
        }

        signSource.append("secretKey").append("=").append(activityProperties.getTaoqi365SecertKey());

        // 附加签名
        sourceUrl += "&sign=" + MD5Util.hgmd5(signSource.toString()).toUpperCase();

        return sourceUrl;
    }
}
