package com.bxm.fossicker.activity.service.invite;

import com.bxm.fossicker.activity.facade.enums.InviteTypeEnum;
import com.bxm.fossicker.activity.facade.model.UserInviteRelationDTO;
import com.bxm.fossicker.activity.model.param.FriendsListParam;
import com.bxm.fossicker.activity.model.vo.UserInviteRelation;
import com.bxm.fossicker.activity.model.vo.UserInvitedVo;
import com.bxm.newidea.component.vo.Message;
import com.github.pagehelper.Page;

import java.math.BigDecimal;
import java.util.List;

/**
 * 邀请关系service
 *
 * @ClassName InviteRelationService
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/7/1 17:34
 * @Version 1.0.0
 **/
public interface InviteRelationService {

    /**
     * 判断该用户是否已经绑定了可用的邀请关系
     *
     * @param userId 用户id
     * @return 查询是否已经有绑定成功的邀请关系
     */
    Boolean hasInviteRelation(Long userId);

    /**
     * 添加邀请关系，同时更新用户信息
     *
     * @param userId        上级用户id
     * @param invitedUserId 当前用户id
     * @return 添加结果
     */
    Boolean addRelation(Long userId, Long invitedUserId);

    /**
     * 根据手机号添加邀请关系-因为来源是站外注册,所以邀请关系状态为0,仅建立邀请关系
     * @param userId 邀请人用户id
     * @param phoneNo 被邀请人手机号
     * @return
     */
    Boolean addRelationByPhone(Long userId, String phoneNo);

    /**
     * 绑定邀请关系
     *
     * @param userId         用户id
     * @param superiorUserId 上级用户id
     * @return
     */
    Boolean bindRelation(Long userId, Long superiorUserId);

    /**
     * 成功绑定绑定邀请关系
     *
     * @param userId         用户id
     * @param superiorUserId 上级用户id
     * @return
     */
    Boolean bindSuccessRelation(Long userId, Long superiorUserId,String currVer);

    /**
     * 获取当前用户邀请成功的被邀请人信息
     *
     * @param userId 用户id
     * @return 被邀请人信息
     */
    List<UserInvitedVo> getInvitedList(Long userId);

    /**
     * 更新提醒状态为已提醒
     *
     * @param userId    邀请人id
     * @param invitedId 被邀请人id
     */
    Boolean updateRemind(Long userId, Long invitedId);

    /**
     * 每日0点更新提醒状态为未提醒
     */
    void initRemindStatus();

    /**
     * 好友总数
     * @param userId 用户id
     * @return 好友总数
     */
    Integer getFriendsNum(Long userId);

    /**
     * 获取收益-在现金收益版本后的邀请关系建立
     * @param userId 用户id
     * @return 现金收益
     */
    BigDecimal getEarning(Long userId);

    /**
     * 获取好友数量-根据奖励版本(现金奖励的版本)
     * @param userId 用户
     * @return 现金奖励的版本的好友数
     */
    Integer getFriendsNumByVersion(Long userId);

    /**
     * 获取好友列表
     * @param userId 用户id
     * @return
     */
    List<UserInviteRelation> getFriendsList(Long userId);

    /**
     * 分页获取所有好友的列表
     * @param friendsListParam 请求参数
     * @return 好友列表的分页信息
     */
    Page<UserInviteRelation> getAllFriendsList(FriendsListParam friendsListParam);

    /**
     * 奖励老用户
     * @return 请求结果
     */
    Boolean rewardOldFriends();

    /**
     * 添加老用户的邀请关系
     * @return 请求结果
     */
    Boolean addOldRelation();

    /**
     * 完成绑定信息之后，真正的邀请成功
     * 会给邀请人发送邀请奖励，并标记为真正成功
     * @param invitedId 被邀请人id
     * @param userId 邀请人id
     * @return 请求结果
     */
    @Deprecated
    Message inviteFinalSuccess(Long invitedId, Long userId);

    /**
     * 完成绑定信息之后，真正的邀请成功
     * 会给邀请人发送邀请奖励，并标记为真正成功
     * @param invitedId 被邀请人id
     * @param userId 邀请人id
     * @return 请求结果
     */
    Message inviteFinalSuccessForV2(Long invitedId, Long userId);

    /**
     * 获取成功邀请的好友-弹窗需求(仅记录成功邀请的好友数)
     * @param userId 用户id
     * @return
     */
    Integer getSuccessInvitationInfo(Long userId);

    /**
     * 删除成功邀请的好友-弹窗需求
     * @param userId 用户id
     * @return 删除结果
     */
    Boolean removeSuccessInvitation(Long userId);

    /**
     * 更新现金奖励vip信息
     * @param userId 用户id
     * @param invitedId 被邀请人id
     * @return 更新结果
     */
    Boolean updateRewardVip(Long userId, Long invitedId, BigDecimal rewardAmt);

    /**
     * 更新金币奖励vip信息
     * @param userId 用户id
     * @param invitedId 被邀请人id
     * @return 更新结果
     */
    Boolean updateGoldRewardVip(Long userId, Long invitedId, Integer rewardAmt);

    /**
     * 更新邀请表里的邀请关系
     * @param userId
     * @param invitedId
     * @return
     */
    Message updateInviteType(Long userId, Long invitedId, InviteTypeEnum inviteTypeEnum);

    /**
     * 获取用户首次现金邀请奖励的邀请记录
     * @param userId
     * @return
     */
    UserInviteRelationDTO getFirstSuccessCashInviteRelationInfo(Long userId);
    /**
     * 2.2.2版本获取成功邀请的好友数量
     * @param userId 用户id
     * @return
     */
    Integer getNewVersionSuccessInviteNum(Long userId);

}
