package com.bxm.fossicker.activity.service.invite.impl;

import com.bxm.fossicker.activity.facade.InviteRelationFacadeService;
import com.bxm.fossicker.activity.facade.enums.InviteTypeEnum;
import com.bxm.fossicker.activity.service.invite.InviteRelationService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Service
public class InviteRelationFacadeServiceImpl implements InviteRelationFacadeService {

    @Autowired
    @Lazy
    private InviteRelationService inviteRelationService;

    @Override
    public Integer getSuccessInvitationInfo(Long userId) {
        return inviteRelationService.getSuccessInvitationInfo(userId);
    }

    @Override
    public Boolean removeSuccessInvitation(Long userId) {
        return inviteRelationService.removeSuccessInvitation(userId);
    }

    @Override
    public Boolean bindSuccessRelation(Long userId, Long superiorUserId,String currVer) {
        return inviteRelationService.bindSuccessRelation(userId, superiorUserId,currVer);
    }

    @Override
    public Boolean updateRewardVip(Long userId, Long invitedId, BigDecimal rewardAmt) {
        return inviteRelationService.updateRewardVip(userId, invitedId, rewardAmt);
    }

    @Override
    public Boolean updateGoldRewardVip(Long userId, Long invitedId, Integer rewardAmt) {
        return inviteRelationService.updateGoldRewardVip(userId, invitedId, rewardAmt);
    }

    @Override
    public Message inviteFinalSuccess(Long invitedId, Long userId) {
        return inviteRelationService.inviteFinalSuccess(invitedId, userId);
    }

    @Override
    public Message updateInviteType(Long userId, Long invitedId, InviteTypeEnum inviteTypeEnum) {
        return inviteRelationService.updateInviteType(userId, invitedId, inviteTypeEnum);
    }

    @Override
    public Integer getNewVersionSuccessInviteNum(Long userId) {
        return inviteRelationService.getNewVersionSuccessInviteNum(userId);
    }
}
