package com.bxm.fossicker.activity.service.rush.impl;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.domain.ActivityRushMapper;
import com.bxm.fossicker.activity.model.dto.RushActivityDTO;
import com.bxm.fossicker.activity.model.vo.ActivityRush;
import com.bxm.fossicker.activity.service.rush.RushActivityService;
import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class RushActivityServiceImpl extends BaseService implements RushActivityService {

    private final ActivityRushMapper activityRushMapper;

    private final RedisStringAdapter redisStringAdapter;

    @Override
    public RushActivityDTO getRushActivity(Long id) {
        return get(id);
    }

    private RushActivityDTO get(Long id) {
        RushActivityDTO rushActivityDTO
                = redisStringAdapter.get(ActivityRedisKeyConstant.RUSH_INFO_MAP_KEY.copy(), RushActivityDTO.class);
        if (null == rushActivityDTO) {
            ActivityRush activityRush = activityRushMapper.selectByPrimaryKey(id);
            if (null != activityRush) {
                rushActivityDTO = convert(activityRush);
                redisStringAdapter.set(ActivityRedisKeyConstant.RUSH_INFO_MAP_KEY.copy(), rushActivityDTO);
            }
        }

        return rushActivityDTO;
    }

    @Override
    public List<ActivityRush> listActivityRush() {
        return activityRushMapper.listActivityRush();
    }

    @Override
    public Message updateOpenTime(ActivityRush activityRush) {
        activityRushMapper.updateOpenTime(activityRush);
        return Message.build(true);
    }

    @Override
    public Message updateStatus(ActivityRush activityRush) {
        activityRushMapper.updateStatus(activityRush);
        return Message.build(true);
    }

    private RushActivityDTO convert(ActivityRush activityRush) {
        return RushActivityDTO.builder()
                .id(activityRush.getId())
                .title(activityRush.getTitle())
                .desc(activityRush.getDesc())
                .goodsName(activityRush.getGoodsName())
                .goodsImgUrl(JSONObject.parseArray(activityRush.getGoodsImgUrl(), String.class))
                .goodsPrice(activityRush.getGoodsPrice())
                .goodsNum(activityRush.getGoodsNum())
                .openTime(activityRush.getOpenTime())
                .endTime(activityRush.getEndTime())
                .status(activityRush.getStatus())
                .build();
    }
}
