package com.bxm.fossicker.activity.service.sign;

import com.bxm.fossicker.activity.model.dto.SignAndInfoDTO;
import com.bxm.fossicker.activity.model.dto.SignDto;
import com.bxm.fossicker.activity.model.dto.SignTodayDTO;

/**
 * 签到服务
 *
 * @ClassName SignService
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/7/3 11:10
 * @Version 1.0.0
 **/
public interface SignService {
    /**
     * 获取签到列表
     *
     * @param userId 用户id
     * @return 签到信息
     */
    SignDto signInfo(Long userId);
    /**
     * 获取7天签到列表
     *
     * @param userId 用户id
     * @return 签到信息
     */
    SignDto signInfoSeven(Long userId);

    /**
     * 获取签到奖励金币数-须确保已经签到过
     * @param userId 用户id
     * @return 签到奖励金币数
     */
    Integer getSignReward(Long userId);

    /**
     * 判斷用戶今日是否签到
     * @param userId
     * @return
     */
    boolean isSignToday(Long userId);

    /**
     * 获取当天签到信息
     *
     * @param userId 用户id
     * @return 签到信息
     */
    SignTodayDTO getTodaySignInfo(Long userId);

    /**
     * 是否已经断签
     * @param userId
     * @return
     */
    boolean isStopSigned(Long userId);

    /**
     * 签到
     * @param userId 用户id
     * @return true-签到成功,false-签到失败
     */
    SignAndInfoDTO signAndInfo(Long userId);

}
