package com.bxm.fossicker.activity.service.sign.impl;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.facade.ActivitySignFacadeService;
import com.bxm.fossicker.activity.facade.constant.ActivityWithdrawType;
import com.bxm.fossicker.activity.model.SignWithdrawDaysModel;
import com.bxm.fossicker.activity.service.WithdrawService;
import com.bxm.fossicker.activity.service.config.SignConfig;
import com.bxm.fossicker.activity.service.sign.ActivitySignService;
import com.bxm.fossicker.activity.service.sign.SignService;
import com.bxm.fossicker.enums.WithdrawTypeEnum;
import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Service
public class ActivitySignServiceImpl implements ActivitySignService, ActivitySignFacadeService {


    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private SignConfig signConfig;

    private SignService signService;

    /**
     * 提现服务 不可以直接使用
     */
    private WithdrawService withdrawService;

    private WithdrawService getWithdrawService() {
        if (null == withdrawService) {
            withdrawService = SpringContextHolder.getBean(WithdrawService.class);
        }
        return withdrawService;
    }

    private SignService getSignService(){
        if (null == signService) {
            signService = SpringContextHolder.getBean(SignService.class);
        }
        return signService;
    }

    @Override
    public Boolean doSign(Long userId) {
        KeyGenerator activitySignKey = ActivityRedisKeyConstant.ACTIVITY_SIGN_DAY;

        //记录连续活动签到天数
        redisHashMapAdapter.increment(activitySignKey, userId.toString(), 1);


        Long signedDays = redisHashMapAdapter.getLong(activitySignKey, userId.toString());
        addWithdraw(userId, signedDays.intValue());

        return true;
    }

    @Override
    public Integer getSignedDay(Long userId) {
        KeyGenerator activitySignKey = ActivityRedisKeyConstant.ACTIVITY_SIGN_DAY;

        Long signedDays = redisHashMapAdapter.getLong(activitySignKey, userId.toString());

        return signedDays.intValue();
    }

    @Override
    public boolean usedChance(Long userId) {
        KeyGenerator activitySignKey = ActivityRedisKeyConstant.ACTIVITY_SIGN_DAY;

        redisHashMapAdapter.remove(activitySignKey, userId.toString());
        return true;
    }

    @Override
    public void checkInfo() {
        //遍历key中的所有
        KeyGenerator activitySignKey = ActivityRedisKeyConstant.ACTIVITY_SIGN_DAY;

        Map<String, Long> userIdMap = redisHashMapAdapter.entries(activitySignKey, Long.class);

        Set<String> userIdSet = userIdMap.keySet();
        userIdSet.forEach(userId -> {
            Long userIdLong = Long.valueOf(userId);
            if (getSignService().isStopSigned(userIdLong)) {
                getWithdrawService().used(userIdLong);

            }
        });

    }

    /**
     * 添加活动提现
     */
    private void addWithdraw(Long userId, Integer signedDays) {
        List<SignWithdrawDaysModel> withdrawDaysModels = JSONObject.parseArray(signConfig.getWithdrawDays(), SignWithdrawDaysModel.class);
        Map<Integer, String> withdrawDaysModelsMap = withdrawDaysModels.stream().collect(Collectors.toMap(SignWithdrawDaysModel::getDays, SignWithdrawDaysModel::getType));
        if (withdrawDaysModelsMap.containsKey(signedDays)) {
            getWithdrawService().add(userId, WithdrawTypeEnum.valueOf(withdrawDaysModelsMap.get(signedDays)));
        }
        // 暂时写死
        // 个
        // 丨
        // 丨
        //  说的好像以后会改一样
        if (Objects.nonNull(signedDays)
                // 如果符合新版本的签到天 则增加提现机会
                && signedDays % signConfig.getNewSingDays() == 0) {
            getWithdrawService().add(userId, ActivityWithdrawType.NEW_SIGN_CHANCE);
        }
    }
}
