package com.bxm.fossicker.activity.service.task.impl;

import com.bxm.fossicker.activity.domain.ActivityTaskMapper;
import com.bxm.fossicker.activity.service.task.NewUserActivityTaskService;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 新手任务
 *
 * @author xin.zhao
 */
@Log4j2
@Service
public class NewUserActivityTaskServiceImpl implements NewUserActivityTaskService {

    private final ActivityTaskMapper taskMapper;

    @Autowired
    public NewUserActivityTaskServiceImpl(ActivityTaskMapper taskMapper) {
        this.taskMapper = taskMapper;
    }


    @Override
    public Boolean updateReward(Long userId, String taskCode) {
        if (null == userId || StringUtils.isBlank(taskCode)) {
            return null;
        }
        // 修改任务状态为已领取
        return taskMapper.updateReward(userId, taskCode);
    }
}
