package com.bxm.fossicker.activity.service.telephonecharge;

import com.bxm.fossicker.activity.model.dto.telephonecharge.TelephoneChargeListDTO;
import com.bxm.fossicker.activity.model.dto.telephonecharge.UseTelephoneChargeDTO;
import com.bxm.fossicker.activity.model.dto.telephonecharge.UserTelephoneChargeDTO;
import com.bxm.fossicker.activity.model.param.telephonecharge.TelephoneChargeListParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * @author lowi
 * @date 2021/4/12 10:53
 */
public interface TelephoneChargeService {


    /**
     * 用户话费列表
     *
     * @param telephoneChargeListParam 请求参数
     * @return 返回话费列表结果
     */
    PageWarper<TelephoneChargeListDTO> getList(TelephoneChargeListParam telephoneChargeListParam);

    /**
     * 使用话费
     *
     * @param userId 用户id
     * @param id     话费id
     * @return 返回使用信息
     */
    UseTelephoneChargeDTO useTelephoneCharge(Long userId, Long id);

    /**
     * 获取用户话费信息
     *
     * @param userId 用户id
     * @return 话费信息
     */
    UserTelephoneChargeDTO getUserTelephoneChargeInfo(Long userId);

    /**
     * 把过期的话费账户信息更新
     */
    void updateUserAccountTelephoneCharge();
}
