package com.bxm.fossicker.activity.service.telephonecharge.impl;

import com.bxm.fossicker.activity.config.TelephoneChargeConfig;
import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.domain.ActivityTelephoneChargeMapper;
import com.bxm.fossicker.activity.enums.TelephoneChargeStatusEnum;
import com.bxm.fossicker.activity.facade.TelephoneChargeFacadeService;
import com.bxm.fossicker.activity.model.TelephoneChargeRuleDTO;
import com.bxm.fossicker.activity.model.entry.ActivityTelephoneCharge;
import com.bxm.fossicker.activity.model.enums.InitCostEnum;
import com.bxm.fossicker.activity.model.param.telephonecharge.InitTelephoneChargeParam;
import com.bxm.fossicker.activity.service.telephonecharge.impl.strategy.TelephoneChargeContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @author lowi
 * @date 2021/4/12 10:53
 */
@Slf4j
@Service
@AllArgsConstructor
public class TelephoneChargeFacadeServiceImpl implements TelephoneChargeFacadeService {
    private final TelephoneChargeConfig telephoneChargeConfig;

    private final ActivityTelephoneChargeMapper activityTelephoneChargeMapper;

    private final TelephoneChargeContext telephoneChargeContext;

    private final RedisHashMapAdapter redisHashMapAdapter;

    private final SequenceCreater sequenceCreater;

    private final DistributedLock distributedLock;


    @Override
    public void addTelephoneChargeList(Long userId, Byte source) {
        Map useRuleMap = JSONObject.parseObject(telephoneChargeConfig.getUseRule(), Map.class);
        if (Objects.isNull(useRuleMap)) {
            log.error("apollo发放规则未配置，请配置发放规则activity.config.telephonecharge.use-rule");
            return;
        }
        TelephoneChargeRuleDTO telephoneChargeRuleDTO = new TelephoneChargeRuleDTO();
        //第5个月及之后，需要每日看20个激励视频，在本月内看满20天可使用；获取到最后一个规则
        for (int month = 1; month <= telephoneChargeConfig.getMonth(); month++) {
            if (Objects.isNull(useRuleMap.get(month))) {
                break;
            } else {
                telephoneChargeRuleDTO = JSONObject.parseObject(JSON.toJSONString(useRuleMap.get(month)), TelephoneChargeRuleDTO.class);
            }
        }
        InitTelephoneChargeParam build = InitTelephoneChargeParam.builder()
                .userId(userId)
                .source(source)
                .lastTelephoneChargeRule(telephoneChargeRuleDTO)
                .useRuleMap(useRuleMap)
                .build();
        ActivityTelephoneCharge lastMonthExistData = activityTelephoneChargeMapper.getLastMonthExistData(userId);
        //如果最后一条记录不存在，说明是新的数据
        if (Objects.isNull(lastMonthExistData)) {
            build.setType(InitCostEnum.FIRST_INIT.getType());
            telephoneChargeContext.initTelephoneCharge(build);
            return;
        }
        Date currDate = new Date();
        //如果最后一条记录存在，并且最后一条使用的开始时间比当前大，直接往后排
        if (currDate.getTime() <= lastMonthExistData.getUseStartDate().getTime()) {
            build.setType(InitCostEnum.EXIST_NEXT_MONTH.getType());
            build.setLastTelephoneCharge(lastMonthExistData);
            telephoneChargeContext.initTelephoneCharge(build);
            return;
        }
        //如果最后一条记录存在，并且最后一条使用的结束时间也没当前大，直接从当前往后排
        if (currDate.getTime() >= lastMonthExistData.getUseEndDate().getTime()) {
            build.setType(InitCostEnum.EXIST_CURR_MONTH.getType());
            telephoneChargeContext.initTelephoneCharge(build);
        }
    }


    @Override
    public void seeVideoGainCost(Long userId) {
        Date currDate = new Date();
        ActivityTelephoneCharge activityTelephoneCharge = activityTelephoneChargeMapper.getCurrMonthTelephoneChargeByUserId(userId, currDate);
        if (Objects.isNull(activityTelephoneCharge)) {
            log.warn("看视频得话费回调根本没这个用户的话费列表，userId={},date={}", userId, currDate);
            return;
        }
        if (Objects.equals(activityTelephoneCharge.getStatus(), TelephoneChargeStatusEnum.USED.getStatus())) {
            log.warn("看视频得话费回调，这个用户的话费列表这个月已经使用过了，activityTelephoneCharge={}", activityTelephoneCharge);
            return;
        }
        if (activityTelephoneCharge.getFirstMonth()) {
            log.warn("第一个月 不需要看视频，activityTelephoneCharge={}", activityTelephoneCharge);
            return;
        }
        String requestId = sequenceCreater.nextStringId();
        String lockKey = ActivityRedisKeyConstant.ADD_SEE_VIDEO_LOCK.copy().appendKey(userId).gen();
        if (!distributedLock.lock(lockKey, requestId, 2, TimeUnit.SECONDS)) {
            log.warn("回调增加用户看视频次数过于频繁");
            return;
        }

        KeyGenerator key = builderRedisKey().appendKey(DateUtils.formatDate(currDate));
        int todaySeeVideoNum = 0;
        Integer num = redisHashMapAdapter.get(key, userId.toString(), Integer.class);
        if (Objects.isNull(num)) {
            redisHashMapAdapter.put(key, userId.toString(), 1);
            //数据只保留1天
            redisHashMapAdapter.expire(key, 24 * 60 * 60);
            todaySeeVideoNum = 1;
        } else {
            //看视频加数量，因为视频都需要时间，这里就不做原子性操作了
            redisHashMapAdapter.put(key, userId.toString(), num + 1);
            todaySeeVideoNum = num + 1;
        }
        //当今天看视频的数量达到了要求次数，增加看视频完成天数
        if (todaySeeVideoNum == activityTelephoneCharge.getTodayNum()) {
            activityTelephoneChargeMapper.updateFinishDayNum(activityTelephoneCharge.getId());
        }
        distributedLock.unlock(lockKey, requestId);
    }

    @Override
    public void addUserSeeVideoDayNum(Long userId) {
        Date currDate = new Date();
        ActivityTelephoneCharge activityTelephoneCharge = activityTelephoneChargeMapper.getCurrMonthTelephoneChargeByUserId(userId, currDate);
        if (Objects.isNull(activityTelephoneCharge)) {
            log.warn("addUserSeeVideoDayNum根本没这个用户的话费列表，userId={},date={}", userId, currDate);
            return;
        }
        if (Objects.equals(activityTelephoneCharge.getStatus(), TelephoneChargeStatusEnum.USED.getStatus())) {
            log.warn("看视频得话费回调，这个用户的话费列表这个月已经使用过了，activityTelephoneCharge={}", activityTelephoneCharge);
            return;
        }
        if (Objects.equals(activityTelephoneCharge.getFinishDayNum(), activityTelephoneCharge.getNeedDayNum())) {
            return;
        }
        activityTelephoneChargeMapper.updateFinishDayNum(activityTelephoneCharge.getId());
    }

    private KeyGenerator builderRedisKey() {
        return ActivityRedisKeyConstant.COST_SEE_VIDEO_NUM.copy();
    }

}
