package com.bxm.fossicker.activity.service.telephonecharge.impl;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.domain.ActivityTelephoneChargeMapper;
import com.bxm.fossicker.activity.enums.TelephoneChargeStatusEnum;
import com.bxm.fossicker.activity.model.dto.telephonecharge.TelephoneChargeListDTO;
import com.bxm.fossicker.activity.model.dto.telephonecharge.UseTelephoneChargeDTO;
import com.bxm.fossicker.activity.model.dto.telephonecharge.UserTelephoneChargeDTO;
import com.bxm.fossicker.activity.model.entry.ActivityTelephoneCharge;
import com.bxm.fossicker.activity.model.param.telephonecharge.TelephoneChargeListParam;
import com.bxm.fossicker.activity.service.telephonecharge.TelephoneChargeService;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.TelephoneChargeAddParam;
import com.bxm.fossicker.user.model.dto.AccountDetailDto;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * @author lowi
 * @date 2021/4/12 10:53
 */
@Slf4j
@Service
@AllArgsConstructor
public class TelephoneChargeServiceImpl implements TelephoneChargeService {

    private final ActivityTelephoneChargeMapper activityTelephoneChargeMapper;

    private final RedisHashMapAdapter redisHashMapAdapter;

    private final AccountFacadeService accountFacadeService;

    @Override
    public PageWarper<TelephoneChargeListDTO> getList(TelephoneChargeListParam telephoneChargeListParam) {
        if (Objects.isNull(telephoneChargeListParam.getStatus())) {
            telephoneChargeListParam.setStatus(0);
        }
        Page<ActivityTelephoneCharge> activityTelephoneChargePageWarper = startPage(telephoneChargeListParam).doSelectPage(() ->
        {
            activityTelephoneChargeMapper.getActivityTelephoneChargeList(telephoneChargeListParam);
        });
        List<ActivityTelephoneCharge> activityTelephoneChargeList = activityTelephoneChargePageWarper.getResult();
        List<TelephoneChargeListDTO> chargeListDTOS = new ArrayList<>();
        //第一次获得话费的当月,展示第二个月的使用条件
        //非-第一次获得话费的当月,展示当月的使用条件和看视频次数

        //第一次生成话费记录下生成时间
        KeyGenerator key = ActivityRedisKeyConstant.USER_EXIST_COST_LIST.copy();
        String isExistSeeCostDate = redisHashMapAdapter.get(key, telephoneChargeListParam.getUserId().toString(), String.class);
        Date firstInitDate = null;
        Date secondDate = null;
        //获取得到话费的日期 和 第二个月日期
        if (StringUtils.isNotBlank(isExistSeeCostDate)) {
            firstInitDate = DateUtils.parseDate(isExistSeeCostDate);
            secondDate = org.apache.commons.lang3.time.DateUtils.addMonths(firstInitDate, 1);
        }
        boolean firstMonthTelephoneCharge = false;
        for (int i = 0; i < activityTelephoneChargeList.size(); i++) {
            TelephoneChargeListDTO telephoneChargeListDTO = new TelephoneChargeListDTO();
            ActivityTelephoneCharge activityTelephoneCharge = activityTelephoneChargeList.get(i);
            //只有第一页展示一些额外信息
            if (telephoneChargeListParam.getPageNum() == 1) {
                //默认 第一条，展示当月的使用条件和看视频次数
                if (!activityTelephoneCharge.getFirstMonth() && i == 0) {
                    //如果列表数据第一条正好为，获取得到话费的第二个月，则只展示时间不展示进度条
                    boolean isSecondMonth = Objects.nonNull(secondDate) && secondDate.getTime() >= activityTelephoneCharge.getUseStartDate().getTime() && secondDate.getTime() <= activityTelephoneCharge.getUseEndDate().getTime();
                    if (!isSecondMonth) {
                        telephoneChargeListDTO.setTodayNum(activityTelephoneCharge.getTodayNum());
                        telephoneChargeListDTO.setFinishDayNum(activityTelephoneCharge.getFinishDayNum());
                        telephoneChargeListDTO.setNeedDayNum(activityTelephoneCharge.getNeedDayNum());
                    }

                    telephoneChargeListDTO.setUseStartDate(activityTelephoneCharge.getUseStartDate());
                    telephoneChargeListDTO.setUseEndDate(activityTelephoneCharge.getUseEndDate());

                }
                if (firstMonthTelephoneCharge) {
                    telephoneChargeListDTO.setUseStartDate(activityTelephoneCharge.getUseStartDate());
                    telephoneChargeListDTO.setUseEndDate(activityTelephoneCharge.getUseEndDate());
                    firstMonthTelephoneCharge = false;
                }
                //第一次获得话费的当月,展示第二个月的使用条件
                if (activityTelephoneCharge.getFirstMonth()) {
                    firstMonthTelephoneCharge = true;
                }
            }
            telephoneChargeListDTO.setId(activityTelephoneCharge.getId().toString());
            telephoneChargeListDTO.setUserId(activityTelephoneCharge.getUserId());
            telephoneChargeListDTO.setStatus(activityTelephoneCharge.getStatus());
            telephoneChargeListDTO.setAmount(activityTelephoneCharge.getAmount());
            telephoneChargeListDTO.setUsedDate(activityTelephoneCharge.getUsedTime());
            telephoneChargeListDTO.setExpireDate(activityTelephoneCharge.getExpiredTime());

            chargeListDTOS.add(telephoneChargeListDTO);
        }
        PageWarper pageWarper = new PageWarper<>(activityTelephoneChargePageWarper);
        pageWarper.setList(chargeListDTOS);
        return pageWarper;
    }

    @Override
    public UseTelephoneChargeDTO useTelephoneCharge(Long userId, Long id) {
        ActivityTelephoneCharge activityTelephoneCharge = activityTelephoneChargeMapper.selectByPrimaryKey(id);
        if (Objects.isNull(activityTelephoneCharge)) {
            return UseTelephoneChargeDTO.builder().status(-1).msg("信息不存在").build();
        }
        if (Objects.equals(activityTelephoneCharge.getStatus(), TelephoneChargeStatusEnum.USED.getStatus())) {
            return UseTelephoneChargeDTO.builder().status(-1).msg("该月话费已被领取").build();
        }
        //如果用户第一次的第一个月，不需要看视频直接领取
        if (activityTelephoneCharge.getFirstMonth()) {
            //调用话费内部接口
            if (!addWithdrawalTelephoneCharge(activityTelephoneCharge.getAmount(), activityTelephoneCharge.getUserId(), id)) {
                return UseTelephoneChargeDTO.builder().status(-1).msg("操作账户失败").build();
            }
            //更新状态
            updateTelephoneChargeStatus(activityTelephoneCharge.getId(), TelephoneChargeStatusEnum.USED.getStatus());
            return UseTelephoneChargeDTO.builder().status(3).msg("10元").build();
        }
        if (Objects.equals(activityTelephoneCharge.getStatus(), TelephoneChargeStatusEnum.SHOW.getStatus())) {
            return UseTelephoneChargeDTO.builder().status(2).msg("本次话费下月可使用").build();
        }
        if (activityTelephoneCharge.getFinishDayNum() >= activityTelephoneCharge.getNeedDayNum()) {
            //调用话费内部接口
            if (!addWithdrawalTelephoneCharge(activityTelephoneCharge.getAmount(), activityTelephoneCharge.getUserId(), id)) {
                return UseTelephoneChargeDTO.builder().status(-1).msg("操作账户失败").build();
            }
            //更新状态
            updateTelephoneChargeStatus(activityTelephoneCharge.getId(), TelephoneChargeStatusEnum.USED.getStatus());
            return UseTelephoneChargeDTO.builder().status(3).msg("10元").build();
        }
        KeyGenerator key = ActivityRedisKeyConstant.COST_SEE_VIDEO_NUM.copy().appendKey(DateUtils.formatDate(new Date()));
        Integer num = redisHashMapAdapter.get(key, userId.toString(), Integer.class);
        if (Objects.isNull(num)) {
            return UseTelephoneChargeDTO.builder().status(0).msg("每日看视频使用话费").build();
        }
        if (num >= activityTelephoneCharge.getTodayNum()) {
            return UseTelephoneChargeDTO.builder().status(1).msg("今日看视频已完成").build();
        } else {
            return UseTelephoneChargeDTO.builder().status(0).msg("每日看视频使用话费").build();
        }
    }

    @Override
    public UserTelephoneChargeDTO getUserTelephoneChargeInfo(Long userId) {
        AccountDetailDto userAccountInfoCash = accountFacadeService.getUserAccountInfoCash(userId);
        UserTelephoneChargeDTO userTelephoneChargeDTO = new UserTelephoneChargeDTO();
        userTelephoneChargeDTO.setNotUseMoney(Objects.isNull(userAccountInfoCash) ? new BigDecimal(0) : userAccountInfoCash.getValidChargeCash());
        return userTelephoneChargeDTO;
    }

    private void updateTelephoneChargeStatus(Long id, Byte status) {
        ActivityTelephoneCharge record = new ActivityTelephoneCharge();
        record.setId(id);
        record.setStatus(status);
        record.setUsedTime(new Date());
        activityTelephoneChargeMapper.updateByPrimaryKeySelective(record);
    }

    private Boolean addWithdrawalTelephoneCharge(BigDecimal amount, Long userId, Long relationId) {
        //调用话费内部接口
        try {
            accountFacadeService.addWithdrawalTelephoneCharge(TelephoneChargeAddParam.builder()
                    .amount(amount)
                    .userId(userId)
                    .cashFlowType(UserCashFlowTypeEnum.CHARGE_INCREMENT)
                    .relationId(relationId)
                    .build());
        } catch (Exception e) {
            log.error("");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public void updateUserAccountTelephoneCharge() {
        Date date = org.apache.commons.lang3.time.DateUtils.addMonths(new Date(), -1);
        //获取上个月还是使用状态的话费，更新为失效话费
        List<ActivityTelephoneCharge> expireCostUserList = activityTelephoneChargeMapper.getExpireCostUserList(date);
        try {
            expireCostUserList.forEach(activityTelephoneCharge -> {
                //调用话费内部接口
                accountFacadeService.addExpireTelephoneCharge(TelephoneChargeAddParam.builder()
                        .amount(activityTelephoneCharge.getAmount())
                        .userId(activityTelephoneCharge.getUserId())
                        .cashFlowType(UserCashFlowTypeEnum.CHARGE_INCREMENT)
                        .relationId(activityTelephoneCharge.getId())
                        .build());
            });
        } catch (Exception e) {
            log.error("获取上个月还是使用状态的话费，更新为失效话费出错", e);
        }
    }
}
