package com.bxm.fossicker.activity.service.telephonecharge.impl.strategy;

import com.bxm.fossicker.activity.config.TelephoneChargeConfig;
import com.bxm.fossicker.activity.domain.ActivityTelephoneChargeMapper;
import com.bxm.fossicker.activity.enums.TelephoneChargeStatusEnum;
import com.bxm.fossicker.activity.model.TelephoneChargeRuleDTO;
import com.bxm.fossicker.activity.model.entry.ActivityTelephoneCharge;
import com.bxm.fossicker.activity.model.enums.InitCostEnum;
import com.bxm.fossicker.activity.model.param.telephonecharge.InitTelephoneChargeParam;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.TelephoneChargeAddParam;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 存在列表，并且最后一天信息小于当前时间，直接从当前时间加数据
 * @author lowi
 * @date 2021/4/13 9:49
 */
@Component
@AllArgsConstructor
@Slf4j
public class ExistTelephoneChargeCurrInitStrategy extends InitTelephoneChargeStrategy {

    private final TelephoneChargeConfig telephoneChargeConfig;

    private final SequenceCreater sequenceCreater;

    private final ActivityTelephoneChargeMapper activityTelephoneChargeMapper;

    private final AccountFacadeService accountFacadeService;

    @Override
    public void initTelephoneCharge(InitTelephoneChargeParam initTelephoneChargeParam) {
        Long relationId = sequenceCreater.nextLongId();
        List<ActivityTelephoneCharge> telephoneCharges = initTelephoneChargesList(initTelephoneChargeParam, relationId);
        activityTelephoneChargeMapper.batchInsertData(telephoneCharges);

        //生成用户可使用话费
        accountFacadeService.addUseTelephoneCharge(TelephoneChargeAddParam.builder()
                .amount(telephoneChargeConfig.getMoney().multiply(BigDecimal.valueOf(telephoneChargeConfig.getMonth())))
                .userId(initTelephoneChargeParam.getUserId())
                .cashFlowType(UserCashFlowTypeEnum.CHARGE_INCREMENT)
                .relationId(relationId)
                .build());
    }

    @Override
    public Integer getType() {
        return InitCostEnum.EXIST_CURR_MONTH.getType();
    }

    private List<ActivityTelephoneCharge> initTelephoneChargesList(InitTelephoneChargeParam initTelephoneChargeParam, Long relationId) {
        Date currDate = null;
        List<ActivityTelephoneCharge> telephoneCharges = new ArrayList<>();
        TelephoneChargeRuleDTO ruleDTO = initTelephoneChargeParam.getLastTelephoneChargeRule();
        for (int month = 1; month <= telephoneChargeConfig.getMonth(); month++) {
            if (Objects.isNull(currDate)) {
                currDate = new Date();
            } else {
                currDate = DateUtils.addMonths(currDate, 1);
            }
            Date[] lastDayAndFirstDay = getLastDayAndFirstDay(currDate);
            ActivityTelephoneCharge activityTelephoneCharge = new ActivityTelephoneCharge();
            activityTelephoneCharge.setCreateTime(new Date());
            activityTelephoneCharge.setSource(initTelephoneChargeParam.getSource());
            activityTelephoneCharge.setId(relationId == null ? sequenceCreater.nextLongId() : relationId);
            activityTelephoneCharge.setUserId(initTelephoneChargeParam.getUserId());
            activityTelephoneCharge.setAmount(telephoneChargeConfig.getMoney());
            activityTelephoneCharge.setFirstMonth(Boolean.FALSE);
            Date[] currMonthDate = initTelephoneChargeParam.getCurrMonthDate();
            Date[] nextMonthDate = initTelephoneChargeParam.getNextMonthDate();
            //默认为上锁状态
            activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.LOCK.getStatus());
            //如果是当前月份，则直接设置为可用状态
            if (currDate.getTime() >= currMonthDate[0].getTime() && currDate.getTime() <= currMonthDate[1].getTime()) {
                activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.USE.getStatus());
            }
            //如果是下一月份，则设置为展示状态
            if (currDate.getTime() >= nextMonthDate[0].getTime() && currDate.getTime() <= nextMonthDate[1].getTime()) {
                activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.SHOW.getStatus());
            }
            activityTelephoneCharge.setTodayNum(ruleDTO.getNeedTodayVideoNum());
            activityTelephoneCharge.setNeedDayNum(ruleDTO.getNeedDayNum());
            activityTelephoneCharge.setFinishDayNum(0);
            activityTelephoneCharge.setUseStartDate(lastDayAndFirstDay[0]);
            activityTelephoneCharge.setUseEndDate(lastDayAndFirstDay[1]);
            telephoneCharges.add(activityTelephoneCharge);
            currDate = lastDayAndFirstDay[0];
            relationId = null;
        }
        return telephoneCharges;
    }
}
