package com.bxm.fossicker.activity.service.telephonecharge.impl.strategy;

import com.bxm.fossicker.activity.config.TelephoneChargeConfig;
import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.domain.ActivityTelephoneChargeMapper;
import com.bxm.fossicker.activity.enums.TelephoneChargeStatusEnum;
import com.bxm.fossicker.activity.model.TelephoneChargeRuleDTO;
import com.bxm.fossicker.activity.model.entry.ActivityTelephoneCharge;
import com.bxm.fossicker.activity.model.enums.InitCostEnum;
import com.bxm.fossicker.activity.model.param.telephonecharge.InitTelephoneChargeParam;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.TelephoneChargeAddParam;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author lowi
 * @date 2021/4/13 9:49
 */
@Component
@AllArgsConstructor
@Slf4j
public class FirstInitTelephoneChargeStrategy extends InitTelephoneChargeStrategy {

    private final TelephoneChargeConfig telephoneChargeConfig;

    private final SequenceCreater sequenceCreater;

    private final ActivityTelephoneChargeMapper activityTelephoneChargeMapper;

    private final AccountFacadeService accountFacadeService;

    private final RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public void initTelephoneCharge(InitTelephoneChargeParam initTelephoneChargeParam) {
        Long relationId = sequenceCreater.nextLongId();
        List<ActivityTelephoneCharge> telephoneCharges = initTelephoneChargesList(initTelephoneChargeParam, relationId);
        activityTelephoneChargeMapper.batchInsertData(telephoneCharges);

        //生成用户可使用话费
        accountFacadeService.addUseTelephoneCharge(TelephoneChargeAddParam.builder()
                .amount(telephoneChargeConfig.getMoney().multiply(BigDecimal.valueOf(telephoneChargeConfig.getMonth())))
                .userId(initTelephoneChargeParam.getUserId())
                .cashFlowType(UserCashFlowTypeEnum.CHARGE_INCREMENT)
                .relationId(relationId)
                .build());

        //第一次生成话费记录下生成时间
        KeyGenerator key = ActivityRedisKeyConstant.USER_EXIST_COST_LIST.copy();
        redisHashMapAdapter.put(key, initTelephoneChargeParam.getUserId().toString(),
                com.bxm.newidea.component.tools.DateUtils.formatDate(new Date()));
    }

    @Override
    public Integer getType() {
        return InitCostEnum.FIRST_INIT.getType();
    }

    private List<ActivityTelephoneCharge> initTelephoneChargesList(InitTelephoneChargeParam initTelephoneChargeParam, Long relationId) {
        Map useRuleMap = initTelephoneChargeParam.getUseRuleMap();
        Date currDate = null;
        List<ActivityTelephoneCharge> telephoneCharges = new ArrayList<>();
        for (int month = 1; month <= telephoneChargeConfig.getMonth(); month++) {
            if (Objects.isNull(currDate)) {
                currDate = new Date();
            } else {
                currDate = DateUtils.addMonths(currDate, 1);
            }
            Date[] lastDayAndFirstDay = getLastDayAndFirstDay(currDate);
            TelephoneChargeRuleDTO ruleDTO = JSONObject.parseObject(JSON.toJSONString(useRuleMap.get(month)), TelephoneChargeRuleDTO.class);
            ruleDTO = Objects.nonNull(ruleDTO) ? ruleDTO : initTelephoneChargeParam.getLastTelephoneChargeRule();
            ActivityTelephoneCharge activityTelephoneCharge = new ActivityTelephoneCharge();
            activityTelephoneCharge.setSource(initTelephoneChargeParam.getSource());
            activityTelephoneCharge.setId(relationId == null ? sequenceCreater.nextLongId() : relationId);
            activityTelephoneCharge.setUserId(initTelephoneChargeParam.getUserId());
            activityTelephoneCharge.setAmount(telephoneChargeConfig.getMoney());
            activityTelephoneCharge.setCreateTime(new Date());
            activityTelephoneCharge.setFirstMonth(Boolean.FALSE);
            //默认为上锁状态
            activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.LOCK.getStatus());
            Date[] currMonthDate = initTelephoneChargeParam.getCurrMonthDate();
            Date[] nextMonthDate = initTelephoneChargeParam.getNextMonthDate();
            activityTelephoneCharge.setFinishDayNum(0);
            //如果是当前月份，则直接设置为可用状态,第一个月的可以直接使用
            if (currDate.getTime() >= currMonthDate[0].getTime() && currDate.getTime() <= currMonthDate[1].getTime()) {
                activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.USE.getStatus());
                activityTelephoneCharge.setFinishDayNum(1);
                activityTelephoneCharge.setFirstMonth(Boolean.TRUE);
            }
            //如果是下一月份，则设置为展示状态
            if (currDate.getTime() >= nextMonthDate[0].getTime() && currDate.getTime() <= nextMonthDate[1].getTime()) {
                activityTelephoneCharge.setStatus(TelephoneChargeStatusEnum.SHOW.getStatus());
            }
            activityTelephoneCharge.setTodayNum(ruleDTO.getNeedTodayVideoNum());
            activityTelephoneCharge.setNeedDayNum(ruleDTO.getNeedDayNum());
            activityTelephoneCharge.setUseStartDate(lastDayAndFirstDay[0]);
            activityTelephoneCharge.setUseEndDate(lastDayAndFirstDay[1]);
            telephoneCharges.add(activityTelephoneCharge);
            currDate = lastDayAndFirstDay[0];
            relationId = null;
        }
        return telephoneCharges;
    }
}
