package com.bxm.fossicker.activity.service.telephonecharge.impl.strategy;

import com.bxm.fossicker.activity.model.param.telephonecharge.InitTelephoneChargeParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * @author lowi
 * @date 2021/4/13 9:32
 */
@Component
@Slf4j
public class TelephoneChargeContext {

    private HashMap<Integer, InitTelephoneChargeStrategy> strategyMap;

    public TelephoneChargeContext(List<InitTelephoneChargeStrategy> strategies) {
        strategyMap = new HashMap<>((int) (strategies.size() / .75f) + 1);
        strategies.forEach(entity -> strategyMap.put(entity.getType(), entity));
    }


    public void initTelephoneCharge(InitTelephoneChargeParam initTelephoneChargeParam) {
        InitTelephoneChargeStrategy initTelephoneChargeStrategy = strategyMap.get(initTelephoneChargeParam.getType());
        initTelephoneChargeParam.setCurrMonthDate(InitTelephoneChargeStrategy.getLastDayAndFirstDay(new Date()));
        initTelephoneChargeParam.setNextMonthDate(InitTelephoneChargeStrategy.getLastDayAndFirstDay(DateUtils.addMonths(new Date(), 1)));
        log.info("生成话费请求参数initTelephoneChargeParam：{}", initTelephoneChargeParam);
        initTelephoneChargeStrategy.initTelephoneCharge(initTelephoneChargeParam);
    }
}
