package com.bxm.fossicker.activity.service.unicom.impl;

import com.bxm.fossicker.activity.domain.ActivityUnicomInfoMapper;
import com.bxm.fossicker.activity.domain.ActivityUnicomPhoneInfoMapper;
import com.bxm.fossicker.activity.model.param.UnicomMatchPhoneParam;
import com.bxm.fossicker.activity.model.param.UnicomParam;
import com.bxm.fossicker.activity.model.vo.UnicomInfo;
import com.bxm.fossicker.activity.model.vo.UnicomPhoneInfo;
import com.bxm.fossicker.activity.service.unicom.UnicomService;
import com.bxm.fossicker.activity.service.unicom.util.ValidatorlUtils;
import com.bxm.fossicker.message.enums.SmsTempEnum;
import com.bxm.fossicker.message.facade.SmsFacadeService;
import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;

/**
 * @Author: pf.w
 * @Date: 2020/4/30 14:50
 */
@Service
@Log4j2
public class UnicomServiceImpl implements UnicomService {

    @Resource
    ActivityUnicomInfoMapper activityUnicomInfoMapper;

    @Resource
    ActivityUnicomPhoneInfoMapper activityUnicomPhoneInfoMapper;

    @Autowired
    SmsFacadeService smsFacadeService;
    //浙江省
    private static String PROVINCE = "330000" ;

    @Override
    public Message saveUnicomUserInfo(UnicomParam unicomParam) {
        log.info("unicomParam {}", JSON.toJSONString(unicomParam));

            String checkStr = checkParam(unicomParam);
            if(Objects.nonNull(checkStr)){
                return Message.build().setSuccess(false).setMessage(checkStr);
            }

            saveUnicom(unicomParam);

            return Message.build().setSuccess(true);
    }

    @Override
    public PageWarper<String> getPhoneList(UnicomMatchPhoneParam unicomMatchPhoneParam) {
        log.info("unicomMatchPhoneParam {}", JSON.toJSONString(unicomMatchPhoneParam));
        List<String> phoneList = activityUnicomPhoneInfoMapper.getPhoneList(unicomMatchPhoneParam);
        return new PageWarper<>(phoneList);
    }

    @Override
    public Message sendMsg(String phoneNumb,HttpServletRequest request) {
        log.info("phoneNumb {}" + phoneNumb);
        if(Objects.isNull(phoneNumb) || !Validater.checkPhone(phoneNumb)){
            return Message.build().setSuccess(false).setMessage("手机号格式错误");
        }
        String ip = WebUtils.getIpAddr(request);
       return smsFacadeService.sendSmsCode(phoneNumb,SmsTempEnum.UNCICOME,ip);
    }

    @Transactional(rollbackFor = Exception.class)
    public void saveUnicom(UnicomParam unicomParam){
        UnicomInfo unicomInfo = new UnicomInfo();
        BeanUtils.copyProperties(unicomParam,unicomInfo);
        activityUnicomInfoMapper.saveUnicomInfo(unicomInfo);

        if(Objects.nonNull(unicomParam.getSelectedPhoneNumb())){

            UnicomPhoneInfo unicomPhoneInfo = UnicomPhoneInfo.builder()
                    .idCard(unicomParam.getIdCard())
                    .usable(1)
                    .phoneNumb(unicomParam.getSelectedPhoneNumb().trim())
                    .unicomId(unicomInfo.getId())
                    .build();

            activityUnicomPhoneInfoMapper.updateUnicomPhoneInfo(unicomPhoneInfo);
        }
    }

    private String checkParam(UnicomParam unicomParam){
        if(!ValidatorlUtils.checkIdentityCode(unicomParam.getIdCard())){
            return "身份证格式错误";
        }

        if(!Validater.checkPhone(unicomParam.getPhone())){
            return "手机号格式错误";
        }

        if(!unicomParam.getOwnerProvince().contains(PROVINCE) && StringUtils.isNotBlank(unicomParam
                .getSelectedPhoneNumb())){
            return "非浙江省不能选择卡号！";
        }

        String code = smsFacadeService.getCode(unicomParam.getPhone(),SmsTempEnum.UNCICOME);
        if(!StringUtils.equals(unicomParam.getSmsCode(),code)){
            return "短信验证码错误";
        }else{
            smsFacadeService.rmCode(unicomParam.getPhone(), SmsTempEnum.UNCICOME);
        }
        return null;
    }
}
