package com.bxm.fossicker.activity.service.unicom.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @Author: pf.w
 * @Date: 2020/4/30 15:35
 */

public class ValidatorlUtils {
    /**
     * 身份证号校验 （支持18位）
     *
     * */
    public static boolean checkIdentityCode(String identityCode) {
        char[] ch = identityCode.toCharArray();
        boolean flag1 = verForm(identityCode);
        boolean flag2 = verify(ch);
        if (flag1 == true && flag2 == true) {
            return true;
        }
        return false;
    }
    // <------------------身份证格式的正则校验----------------->
    public static boolean verForm(String num) {
        String reg = "^\\d{15}$|^\\d{17}[0-9Xx]$";
        if (!num.matches(reg)) {
            return false;
        }
        return true;
    }
    // <------------------身份证最后一位的校验算法----------------->
    public static boolean verify(char[] id) {
        int sum = 0;
        int w[] = { 7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2 };
        char[] ch = { '1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2' };
        for (int i = 0; i < id.length - 1; i++) {
            sum += (id[i] - '0') * w[i];
        }
        int c = sum % 11;
        char code = ch[c];
        char last = id[id.length - 1];
        last = last == 'x' ? 'X' : last;
        return last == code;
    }
}
