package com.bxm.fossicker.activity.service.welfare.impl;

import com.bxm.fossicker.activity.config.NewbieWelfareConfig;
import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.service.welfare.NewUserWelfareService;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;

/**
 * @author lowi
 * @date 2021/6/3 19:52
 */
@Service
@AllArgsConstructor
@Slf4j
public class NewUserWelfareServiceImpl implements NewUserWelfareService {

    private final RedisHashMapAdapter redisHashMapAdapter;

    private final AccountFacadeService accountFacadeService;

    private final NewbieWelfareConfig newbieWelfareConfig;

    private final DistributedLock distributedLock;

    private final SequenceCreater sequenceCreate;


    @Override
    public Boolean isSendGold(Long userId) {
        return redisHashMapAdapter.exists(buildUserSendGoldKey(), userId.toString());
    }

    @Override
    public Message sendGold(Long userId) {
        Boolean userSendGold = redisHashMapAdapter.exists(buildUserSendGoldKey(), userId.toString());
        if (userSendGold) {
            return Message.build(false).setMessage("用户已获取过此福利");
        }
        String requestId = sequenceCreate.nextStringId();
        distributedLock.lock(userId.toString(), requestId, 3L, TimeUnit.SECONDS);
        Message message = accountFacadeService.goldRebate(GoldRebateParam.builder()
                .userId(userId)
                .userGoldFlowType(UserGoldFlowTypeEnum.NEWBIE_REGISTER_WELFARE)
                .relationId(null)
                .amount(BigDecimal.valueOf(newbieWelfareConfig.getNewbieWelfare()))
                .build());
        if (message.isSuccess()) {
            redisHashMapAdapter.put(buildUserSendGoldKey(), userId.toString(), Boolean.TRUE);
        }
        distributedLock.unlock(userId.toString(), requestId);
        return message;
    }

    private KeyGenerator buildUserSendGoldKey() {
        return ActivityRedisKeyConstant.NEW_USER_SEND_GOLD;
    }
}
