/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.lottery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.activity.domain.lottery.LotteryParticipantMapper;
import com.bxm.fossicker.activity.lottery.config.LotteryPhaseStatus;
import com.bxm.fossicker.activity.lottery.service.LotteryDrawService;
import com.bxm.fossicker.activity.lottery.service.LotteryParticipantService;
import com.bxm.fossicker.activity.lottery.service.LotteryPhaseService;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryJoinTime;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryParticipantDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryPhaseDetailDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryWinnerCalDTO;
import com.bxm.fossicker.activity.model.param.lottery.LotteryDrawParam;
import com.bxm.fossicker.activity.model.param.lottery.LotteryPhaseQueryParam;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryPhaseBean;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryVirtaulUserBean;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.enums.PushStrategyEnum;
import com.bxm.fossicker.message.facade.PushFacadeService;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.thirdpart.facade.service.WxMpMessageFacadeService;
import com.bxm.fossicker.user.facade.VirtualUserFacadeService;
import com.bxm.fossicker.user.model.entity.VirtualUserBean;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LotteryDrawServiceImpl
implements LotteryDrawService,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(LotteryDrawServiceImpl.class);
    private static final int CAL_NUM = 50;
    private static final ThreadLocal<DateFormat> CUSTOM_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS"));
    private LotteryPhaseService lotteryPhaseService;
    private final LotteryParticipantMapper lotteryParticipantMapper;
    private final VirtualUserFacadeService virtualUserFacadeService;
    private final ActivityProperties activityProperties;
    private LotteryParticipantService lotteryParticipantService;
    private ApplicationContext applicationContext;
    private WxMpMessageFacadeService wxMpMessageFacadeService;
    private final PushFacadeService pushFacadeService;

    @Autowired
    public LotteryDrawServiceImpl(LotteryPhaseService lotteryPhaseService, LotteryParticipantMapper lotteryParticipantMapper, VirtualUserFacadeService virtualUserFacadeService, ActivityProperties activityProperties, WxMpMessageFacadeService wxMpMessageFacadeService, PushFacadeService pushFacadeService) {
        this.lotteryPhaseService = lotteryPhaseService;
        this.lotteryParticipantMapper = lotteryParticipantMapper;
        this.virtualUserFacadeService = virtualUserFacadeService;
        this.activityProperties = activityProperties;
        this.wxMpMessageFacadeService = wxMpMessageFacadeService;
        this.pushFacadeService = pushFacadeService;
    }

    private LotteryParticipantService getLotteryParticipantService() {
        if (this.lotteryParticipantService == null) {
            this.lotteryParticipantService = (LotteryParticipantService)this.applicationContext.getBean(LotteryParticipantService.class);
        }
        return this.lotteryParticipantService;
    }

    @Override
    public void doDraw(Long phaseId, String title) {
        LotteryPhaseDetailDTO phaseDetail = this.lotteryPhaseService.loadCache(phaseId);
        if (phaseDetail.getStatus().intValue() != LotteryPhaseStatus.GOING.getCode()) {
            log.warn("\u6d3b\u52a8\u4e0d\u5904\u7406\u8fdb\u884c\u4e2d\u72b6\u6001\uff0c\u4e0d\u8fdb\u884c\u5f00\u5956\u5904\u7406\uff0cphase:{}", (Object)phaseDetail);
            return;
        }
        LotteryPhaseQueryParam pageParam = this.getLotteryPhaseQueryParam(phaseId, 49);
        List lastJoinUsers = this.lotteryParticipantMapper.getParticipantByPage(pageParam);
        LotteryVirtaulUserBean lastVirtual = this.getLastJoinVirtualUser((LotteryParticipantDTO)lastJoinUsers.get(0));
        lastJoinUsers.add(LotteryParticipantDTO.builder().headImg(lastVirtual.getHeadImg()).joinTime(lastVirtual.getAddTime()).nickName(lastVirtual.getNickname()).userId(lastVirtual.getId()).build());
        LotteryParticipantDTO winner = this.cal(lastJoinUsers, phaseDetail, lastVirtual);
        if (null != winner) {
            LotteryPhaseBean modifyPhase = LotteryPhaseBean.builder().status(Integer.valueOf(LotteryPhaseStatus.FINISH.getCode())).winnerCode(winner.getCode()).winnerHeadUrl(winner.getHeadImg()).winnerId(winner.getUserId()).winnerName(winner.getNickName()).winTime(lastVirtual.getAddTime()).id(phaseId).build();
            this.lotteryPhaseService.closePhase(modifyPhase);
        }
        ((LotteryDrawService)SpringContextHolder.getBean(LotteryDrawService.class)).pushWxMessage(phaseId, title, lastVirtual.getAddTime());
        log.debug("\u6d3b\u52a8\u5df2\u5f00\u5956\uff1a{},\u4e2d\u5956\u4eba\uff1a{}", (Object)phaseDetail, (Object)winner);
    }

    @Override
    @Async
    public void pushWxMessage(Long phaseId, String title, Date time) {
        List realUsers = this.lotteryParticipantMapper.getParticipant(phaseId, Byte.valueOf((byte)0));
        if (CollectionUtils.isEmpty((Collection)realUsers)) {
            log.info("\u6d3b\u52a8\uff1a[{}]\u65e0\u771f\u5b9e\u7528\u6237\u53c2\u4e0e", (Object)phaseId);
            return;
        }
        log.debug("\u5f53\u524d\u6d3b\u52a8:[{}],\u771f\u5b9e\u7528\u6237\uff1a[{}]", (Object)phaseId, JSONObject.toJSON((Object)realUsers));
        Map<Long, Long> userCodeMap = realUsers.stream().collect(Collectors.groupingBy(LotteryParticipantDTO::getUserId, Collectors.counting()));
        String drawTime = DateUtils.formatDateTime((Date)time);
        userCodeMap.forEach((userId, num) -> this.pushFacadeService.push(MixPushParam.builder().notifyType(NotifyEnum.INDIANAPOLIS_DRAW_MSG).userId(userId).addStrategy(PushStrategyEnum.WECHAT).addExtend(NotifyParamEnum.TITLE, (Object)title).addExtend(NotifyParamEnum.TIME, (Object)drawTime).addExtend(NotifyParamEnum.NUM, (Object)String.valueOf(num)).build()));
    }

    private LotteryParticipantDTO cal(List<LotteryParticipantDTO> lastJoinUsers, LotteryPhaseDetailDTO phaseDetail, LotteryVirtaulUserBean lastVirtual) {
        LotteryParticipantDTO res = null;
        List<LotteryParticipantDTO> virtualUsers = this.lotteryParticipantMapper.getVitrualUser(phaseDetail.getPhaseId());
        virtualUsers.forEach(user -> user.setCodeIndex(this.restore(user.getCode())));
        long sum = lastJoinUsers.stream().mapToLong(user -> this.convert(user.getJoinTime())).sum();
        int winnerIndex = (int)(sum % (long)phaseDetail.getConditionNum().intValue());
        int fixMillSeconds = 0;
        for (LotteryParticipantDTO virtualUser : virtualUsers) {
            if (virtualUser.getCodeIndex() < winnerIndex) continue;
            fixMillSeconds = virtualUser.getCodeIndex() - winnerIndex;
            res = virtualUser;
            break;
        }
        if (res == null) {
            virtualUsers = virtualUsers.stream().sorted(Comparator.comparing(LotteryParticipantDTO::getCodeIndex).reversed()).collect(Collectors.toList());
            for (LotteryParticipantDTO virtualUser : virtualUsers) {
                if (virtualUser.getCodeIndex() >= winnerIndex) continue;
                fixMillSeconds = virtualUser.getCodeIndex() - winnerIndex;
                res = virtualUser;
                break;
            }
            log.debug("\u9006\u5e8f\u67e5\u627e\u865a\u62df\u4e2d\u5956\u7528\u6237\uff0c\u4fee\u6b63\u6beb\u79d2\u6570\uff1a{},\u4e2d\u5956\u4eba\uff1a{}", (Object)fixMillSeconds, (Object)res);
        } else {
            log.debug("\u6b63\u5e8f\u67e5\u627e\u865a\u62df\u4e2d\u5956\u7528\u6237\uff0c\u4fee\u6b63\u6beb\u79d2\u6570\uff1a{},\u4e2d\u5956\u4eba\uff1a{}", (Object)fixMillSeconds, res);
        }
        if (res == null) {
            log.error("\u5f00\u5956\u5931\u8d25\uff0c\u672a\u67e5\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u865a\u62df\u7528\u6237,\u6d3b\u52a8\u671f\u6570\uff1a{}", (Object)phaseDetail);
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(lastVirtual.getAddTime());
        calendar.add(14, fixMillSeconds);
        lastVirtual.setAddTime(calendar.getTime());
        log.debug("\u5f00\u5956\u53c2\u6570\uff0c\u603b\u6570\uff1a{}\uff0c\u9884\u8ba1\u4e2d\u5956\u7f16\u53f7\uff1a{}\uff0c\u53c2\u52a0\u6d3b\u52a8\u4eba\u6570\uff1a{}\uff0c\u4fee\u6b63\u6beb\u79d2\u6570\uff1a{}\uff0c\u4fee\u6b63\u540e\u4e2d\u5956\u4eba\u5458\uff1a{},\u4fee\u6b63\u540e\u53c2\u4e0e\u65f6\u95f4\uff1a{}", new Object[]{sum, winnerIndex, phaseDetail.getParticipantNum(), fixMillSeconds, res.getCodeIndex(), CUSTOM_FORMAT.get().format(lastVirtual.getAddTime())});
        LotteryDrawParam joinParam = LotteryDrawParam.builder().userId(lastVirtual.getId()).phaseId(phaseDetail.getPhaseId()).virtual(Boolean.valueOf(true)).lastVirtual(Boolean.valueOf(true)).virtaulUser(lastVirtual).build();
        this.getLotteryParticipantService().addParticipant(joinParam);
        return res;
    }

    private int restore(String code) {
        int codeValue = NumberUtils.toInt((String)code);
        return codeValue - this.activityProperties.getCodePrefix();
    }

    private LotteryVirtaulUserBean getLastJoinVirtualUser(LotteryParticipantDTO lastUser) {
        List virtualUsers = this.virtualUserFacadeService.listVirtualUser(Integer.valueOf(1));
        VirtualUserBean virtualUser = (VirtualUserBean)virtualUsers.get(0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(lastUser.getJoinTime());
        calendar.add(13, 1);
        calendar.set(14, 0);
        return LotteryVirtaulUserBean.builder().id(virtualUser.getId()).sex(virtualUser.getSex()).nickname(virtualUser.getNickname()).headImg(virtualUser.getHeadImg()).addTime(calendar.getTime()).build();
    }

    @Override
    public LotteryWinnerCalDTO getCalProcess(Long phaseId) {
        LotteryPhaseDetailDTO detail = this.lotteryPhaseService.loadCache(phaseId);
        if (detail.getStatus().intValue() != LotteryPhaseStatus.FINISH.getCode()) {
            log.error("\u6d3b\u52a8[{}]\u5c1a\u672a\u7ed3\u675f\uff0c\u8c03\u52a8\u4e86\u67e5\u770b\u8ba1\u7b97\u8fc7\u7a0b\u7684\u65b9\u6cd5", (Object)phaseId);
            return LotteryWinnerCalDTO.builder().build();
        }
        List<LotteryJoinTime> joinTimeList = this.getLastJoinParticipant(phaseId);
        return LotteryWinnerCalDTO.builder().winnerCode(detail.getWinnerCode()).participantNum(detail.getParticipantNum()).joinTimeList(joinTimeList).lastCount(this.sumJoinTime(joinTimeList)).build();
    }

    private List<LotteryJoinTime> getLastJoinParticipant(Long phaseId) {
        LotteryPhaseQueryParam pageParam = this.getLotteryPhaseQueryParam(phaseId, 50);
        List lastJoinUsers = this.lotteryParticipantMapper.getParticipantByPage(pageParam);
        return lastJoinUsers.stream().map(item -> LotteryJoinTime.builder().joinTime(CUSTOM_FORMAT.get().format(item.getJoinTime())).convertTime(this.convert(item.getJoinTime())).build()).collect(Collectors.toList());
    }

    private LotteryPhaseQueryParam getLotteryPhaseQueryParam(Long phaseId, int userNum) {
        LotteryPhaseQueryParam pageParam = new LotteryPhaseQueryParam();
        pageParam.setPageSize(Integer.valueOf(userNum));
        pageParam.setPhaseId(phaseId);
        return pageParam;
    }

    private Long sumJoinTime(List<LotteryJoinTime> joinTimeList) {
        return joinTimeList.stream().mapToLong(LotteryJoinTime::getConvertTime).sum();
    }

    private Long convert(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hour = calendar.get(10);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int millisecond = calendar.get(14);
        String finalNumStr = String.valueOf(hour) + String.format("%02d", minute) + String.format("%02d", second) + String.format("%03d", millisecond);
        return NumberUtils.toLong((String)finalNumStr);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

