/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.lottery.service.impl;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.domain.lottery.LotteryMapper;
import com.bxm.fossicker.activity.lottery.config.LotteryStatus;
import com.bxm.fossicker.activity.lottery.service.LotteryPhaseService;
import com.bxm.fossicker.activity.lottery.service.LotteryService;
import com.bxm.fossicker.activity.model.param.lottery.LotteryQueryPageParam;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryBean;
import com.bxm.fossicker.vo.PageWarper;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LotteryServiceImpl
extends BaseService
implements LotteryService {
    private LotteryMapper lotteryMapper;
    private LotteryPhaseService lotteryPhaseService;
    private RedisHashMapAdapter redisHashMapAdpter;

    @Autowired
    public LotteryServiceImpl(LotteryMapper lotteryMapper, LotteryPhaseService lotteryPhaseService, RedisHashMapAdapter redisHashMapAdpter) {
        this.lotteryMapper = lotteryMapper;
        this.lotteryPhaseService = lotteryPhaseService;
        this.redisHashMapAdpter = redisHashMapAdpter;
    }

    @Override
    public Message addLottery(LotteryBean entity) {
        if (null == entity.getId()) {
            entity.setId(Long.valueOf(this.nextId()));
        }
        entity.setCreateTime(new Date());
        entity.setDeleteFlag(Boolean.valueOf(false));
        entity.setPhaseCount(Integer.valueOf(0));
        entity.setStatus(LotteryStatus.DISABLE.getCode());
        if (null == entity.getOrder()) {
            entity.setOrder(Integer.valueOf(0));
        }
        this.reorder(entity.getId(), entity.getOrder());
        int res = this.lotteryMapper.insert(entity);
        return Message.build((int)res);
    }

    private void reorder(Long lotteryId, int order) {
        List existsLotteryList = this.lotteryMapper.getLotteryByOrder(order);
        if (!CollectionUtils.isEmpty((Collection)existsLotteryList)) {
            if (existsLotteryList.size() == 1 && existsLotteryList.stream().anyMatch(code -> code.equals(lotteryId))) {
                return;
            }
            this.lotteryMapper.updateOrder(order);
        }
    }

    @Override
    public Message modify(LotteryBean entity) {
        Preconditions.checkArgument((null != entity ? 1 : 0) != 0);
        Preconditions.checkArgument((null != entity.getId() ? 1 : 0) != 0);
        this.reorder(entity.getId(), entity.getOrder());
        Message message = Message.build((int)this.lotteryMapper.updateByPrimaryKeySelective(entity));
        message.append(this.lotteryPhaseService.modify(entity));
        this.cleanCache(entity.getId());
        return message;
    }

    private void cleanCache(Long lotteryId) {
        this.redisHashMapAdpter.remove(ActivityRedisKeyConstant.LOTTERY_INFO_MAP_KEY, new String[]{lotteryId.toString()});
    }

    @Override
    public Message remove(Long lotteryId, Long operator) {
        LotteryBean entity = LotteryBean.builder().deleteFlag(Boolean.valueOf(true)).deleter(operator).id(lotteryId).deleteTime(new Date()).build();
        return Message.build((int)this.lotteryMapper.updateByPrimaryKeySelective(entity));
    }

    @Override
    public Message change(Long lotteryId, Byte status) {
        Preconditions.checkArgument((null != lotteryId ? 1 : 0) != 0);
        if (status == null) {
            status = 0;
        }
        LotteryBean lottery = LotteryBean.builder().id(lotteryId).status((int)status.byteValue()).build();
        Message message = Message.build((int)this.lotteryMapper.updateByPrimaryKeySelective(lottery));
        this.cleanCache(lotteryId);
        if (status.byteValue() == LotteryStatus.ENABLE.getCode()) {
            this.lotteryPhaseService.resumePhase(this.loadCache(lotteryId));
        } else {
            this.lotteryPhaseService.cancel(lottery);
        }
        return message;
    }

    @Override
    public LotteryBean loadCache(Long lotteryId) {
        String idStr = Objects.toString(lotteryId);
        LotteryBean lottery = (LotteryBean)this.redisHashMapAdpter.get(ActivityRedisKeyConstant.LOTTERY_INFO_MAP_KEY, idStr, LotteryBean.class);
        if (null == lottery) {
            lottery = this.lotteryMapper.selectByPrimaryKey(lotteryId);
            if (null == lottery) {
                lottery = LotteryBean.builder().id(lotteryId).build();
            }
            this.redisHashMapAdpter.put(ActivityRedisKeyConstant.LOTTERY_INFO_MAP_KEY, idStr, (Object)lottery);
        }
        return lottery;
    }

    @Override
    public PageWarper<LotteryBean> getByPage(LotteryQueryPageParam param) {
        if (null == param) {
            param = new LotteryQueryPageParam();
        }
        List result = this.lotteryMapper.getLotteryByPage(param);
        return new PageWarper(result);
    }
}

