/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.advert.filter.general;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.model.param.AdvertParam;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

@AdverFilter
public class CostJumpFilter
extends AbstractAdvertisementFilter {
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        AdvertParam advertParam = param.getAdvertParam();
        if (Objects.nonNull(advertParam)) {
            KeyGenerator key = ActivityRedisKeyConstant.USER_EXIST_COST_LIST.copy();
            String isExistSeeCostDate = (String)this.redisHashMapAdapter.get(key, advertParam.getUserId().toString(), String.class);
            advertDtos.forEach(advertDto -> {
                String title = advertDto.getTitle();
                if (Objects.equals(title, "\u767e\u5143\u8bdd\u8d39")) {
                    advertDto.setUrl(advertDto.getUrl() + "%26qt_detain%3D" + (StringUtils.isNotBlank((CharSequence)isExistSeeCostDate) ? 0 : 1));
                }
            });
        }
        return true;
    }
}

