/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.advert.filter.general;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.service.Taoqi365ParseUrlService;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@AdverFilter
public class Taoqi365AdvertisementFilter
extends AbstractAdvertisementFilter {
    private final ActivityProperties activityProperties;
    @Autowired
    Taoqi365ParseUrlService taoqi365ParseUrlService;
    private static final String URL_PREFIX = "http://tq.jfshou.cn";

    @Autowired
    public Taoqi365AdvertisementFilter(ActivityProperties activityProperties) {
        this.activityProperties = activityProperties;
    }

    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        advertDtos.forEach(item -> {
            if (StringUtils.startsWithAny((CharSequence)item.getUrl(), (CharSequence[])new CharSequence[]{URL_PREFIX, this.activityProperties.getTaoqi365BaseUrl()})) {
                String afterParseUrl = this.parseUrl(item.getUrl(), param);
                afterParseUrl = StringUtils.replace((String)afterParseUrl, (String)URL_PREFIX, (String)this.activityProperties.getTaoqi365BaseUrl());
                item.setUrl(afterParseUrl);
            }
        });
        return true;
    }

    private String parseUrl(String sourceUrl, AdvertisementFilterParam param) {
        return this.taoqi365ParseUrlService.parseUrl(sourceUrl, param.getAdvertParam().getUserId().toString(), this.activityProperties.getTaoqi365AgentId());
    }
}

