/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.advert.filter.position;

import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.model.enums.AdvertPositionEnum;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.user.facade.dto.UserLoginHistoryDTO;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

@AdverFilter(value={AdvertPositionEnum.USER_PAGE_ICONS})
public class MyIconFilter
extends AbstractAdvertisementFilter {
    @Autowired
    private UserInfoFacadeService infoFacadeService;
    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        boolean showInviteUserIcon = false;
        if (Objects.equals(param.getAdvertParam().getOpenNotice(), Boolean.TRUE)) {
            advertDtos.removeIf(p -> Objects.equals(this.advertConfig.getOpenNoticeName(), p.getTitle()));
            showInviteUserIcon = true;
        }
        if (null != param.getAdvertParam().getUserId()) {
            if (this.redisSetAdapter.exists(ActivityRedisKey.NOT_SHOW_WRITE_INVITE_CODE, (Object)param.getAdvertParam().getUserId()).booleanValue()) {
                advertDtos.removeIf(p -> Objects.equals(this.advertConfig.getInputInviteCodeName(), p.getTitle()));
                showInviteUserIcon = true;
            } else {
                UserInfoDto userInfoDto = param.getUserInfoDto();
                if (null != userInfoDto && null != userInfoDto.getSuperiorUserId() && 0L != userInfoDto.getSuperiorUserId()) {
                    advertDtos.removeIf(p -> Objects.equals(this.advertConfig.getInputInviteCodeName(), p.getTitle()));
                    showInviteUserIcon = true;
                    this.redisSetAdapter.add(ActivityRedisKey.NOT_SHOW_WRITE_INVITE_CODE, new Object[]{param.getAdvertParam().getUserId()});
                } else if (null != userInfoDto) {
                    UserLoginHistoryDTO userLoginHistoryDTO = this.infoFacadeService.getFirstLoginInfo(param.getAdvertParam().getUserId());
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(org.apache.commons.lang.time.DateUtils.addDays((Date)userLoginHistoryDTO.getLastLoginTime(), (int)3));
                    calendar.set(10, 23);
                    calendar.set(12, 59);
                    calendar.set(13, 59);
                    if (DateUtils.after((Date)new Date(), (Date)calendar.getTime())) {
                        advertDtos.removeIf(p -> Objects.equals(this.advertConfig.getInputInviteCodeName(), p.getTitle()));
                        showInviteUserIcon = true;
                        this.redisSetAdapter.add(ActivityRedisKey.NOT_SHOW_WRITE_INVITE_CODE, new Object[]{param.getAdvertParam().getUserId()});
                    }
                }
            }
        }
        if (!showInviteUserIcon) {
            advertDtos.removeIf(p -> Objects.equals(this.advertConfig.getInviteUserName(), p.getTitle()));
        }
        if (StringUtils.compareVersion((String)param.getAdvertParam().getCurVer(), (String)"1.3.0") < 0) {
            advertDtos.removeIf(p -> Objects.equals(this.advertConfig.getCustomer(), p.getTitle()));
        }
        return true;
    }
}

