/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.advert.impl;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.model.enums.AdvertPositionEnum;
import com.bxm.fossicker.activity.model.param.AdvertParam;
import com.bxm.fossicker.activity.service.advert.AdvertisementFilter;
import com.bxm.fossicker.activity.service.advert.AdvertisementFilterChainService;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AdvertFilterChainServiceImpl
implements ApplicationContextAware,
AdvertisementFilterChainService {
    private Map<AdvertPositionEnum, List<AdvertisementFilter>> advertisements = Maps.newHashMap();
    private List<AdvertisementFilter> defaultFilters = Lists.newArrayList();
    @Resource
    private UserInfoFacadeService userInfoFacadeService;

    @Override
    public void filter(List<AdvertDto> advertDtos, AdvertParam advertParam) {
        List<AdvertisementFilter> advertisementFilters;
        if (CollectionUtils.isEmpty(advertDtos)) {
            return;
        }
        AdvertisementFilterParam param = AdvertisementFilterParam.builder().advertParam(advertParam).userInfoFacadeService(this.userInfoFacadeService).position(advertParam.getPosition()).build();
        if (null != this.defaultFilters) {
            for (AdvertisementFilter advertisementFilter : this.defaultFilters) {
                if (advertisementFilter.filter(advertDtos, param)) continue;
                return;
            }
        }
        if (null != (advertisementFilters = this.advertisements.get(AdvertPositionEnum.getByPosition((int)param.getPosition())))) {
            for (AdvertisementFilter advertisementFilter : advertisementFilters) {
                if (advertisementFilter.filter(advertDtos, param)) continue;
                return;
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Collection advertisementFilterMap = applicationContext.getBeansOfType(AdvertisementFilter.class).values();
        advertisementFilterMap.forEach(p -> {
            AdverFilter adverFilter = (AdverFilter)AnnotationUtils.getAnnotation((AnnotatedElement)AopUtils.getTargetClass((Object)p), AdverFilter.class);
            if (null != adverFilter) {
                this.addFilter(adverFilter.value(), (AdvertisementFilter)p);
            }
        });
    }

    private void addFilter(AdvertPositionEnum[] positions, AdvertisementFilter filter) {
        if (null == positions || positions.length == 0) {
            this.defaultFilters.add(filter);
        }
        for (AdvertPositionEnum position : positions) {
            ArrayList advertisementFilters = this.advertisements.get(position);
            if (null == advertisementFilters) {
                advertisementFilters = Lists.newArrayList();
                this.advertisements.put(position, advertisementFilters);
            }
            advertisementFilters.add(filter);
        }
    }
}

