/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.advert.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.fossicker.activity.config.ExternalAdvertConfig;
import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.constants.AdvertPrecondition;
import com.bxm.fossicker.activity.domain.ActivityAdvertMapper;
import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.model.dto.ClassificationDTO;
import com.bxm.fossicker.activity.model.entry.AdvertEntry;
import com.bxm.fossicker.activity.model.enums.AdvertPositionEnum;
import com.bxm.fossicker.activity.model.param.AdvertParam;
import com.bxm.fossicker.activity.model.param.AdvertRelationParam;
import com.bxm.fossicker.activity.model.vo.AppInfoForSwlh;
import com.bxm.fossicker.activity.service.advert.AdvertService;
import com.bxm.fossicker.activity.service.advert.AdvertisementFilterChainService;
import com.bxm.fossicker.activity.service.config.AdverProperties;
import com.bxm.fossicker.base.facade.AppVersionFacadeService;
import com.bxm.fossicker.base.facade.model.EquipmentDTO;
import com.bxm.fossicker.base.facade.param.AppVersionParam;
import com.bxm.fossicker.base.facade.service.EquipmentFacadeService;
import com.bxm.fossicker.base.facade.vo.AppChannelVersionVO;
import com.bxm.fossicker.base.param.UserIdParam;
import com.bxm.fossicker.enums.PlatformEnum;
import com.bxm.fossicker.integration.commodity.service.CommodityInfoFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.taobao.api.request.TbkActivitylinkGetRequest;
import com.taobao.api.response.TbkActivitylinkGetResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AdvertServiceImpl
implements AdvertService {
    private static final Logger log = LogManager.getLogger(AdvertServiceImpl.class);
    private final ActivityAdvertMapper advertMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final AppVersionFacadeService appVersionFacadeService;
    private final AdvertisementFilterChainService advertisementFilterChainService;
    private final UserInfoFacadeService userInfoFacadeService;
    private final ExternalAdvertConfig externalAdvertConfig;
    private final UserInfoFacadeService userInfoService;
    private final RedisStringAdapter redisStringAdapter;
    private final EquipmentFacadeService equipmentFacadeService;
    private final CommodityInfoFacadeService commodityInfoFacadeService;
    private final AdverProperties adverProperties;
    private final OKHttpService okHttpService;
    private TypeReference<List<AdvertDto>> typeReference = new TypeReference<List<AdvertDto>>(){};
    private LoadingCache<Integer, List<AdvertDto>> postionCache;
    private LoadingCache<Long, List<AdvertDto>> detailCache;

    public AdvertServiceImpl(ActivityAdvertMapper advertMapper, RedisHashMapAdapter redisHashMapAdapter, AppVersionFacadeService appVersionFacadeService, AdvertisementFilterChainService advertisementFilterChainService, UserInfoFacadeService userInfoFacadeService, ExternalAdvertConfig externalAdvertConfig, UserInfoFacadeService userInfoService, RedisStringAdapter redisStringAdapter, EquipmentFacadeService equipmentFacadeService, CommodityInfoFacadeService commodityInfoFacadeService, AdverProperties adverProperties, OKHttpService okHttpService) {
        this.advertMapper = advertMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.appVersionFacadeService = appVersionFacadeService;
        this.advertisementFilterChainService = advertisementFilterChainService;
        this.userInfoFacadeService = userInfoFacadeService;
        this.externalAdvertConfig = externalAdvertConfig;
        this.userInfoService = userInfoService;
        this.redisStringAdapter = redisStringAdapter;
        this.equipmentFacadeService = equipmentFacadeService;
        this.commodityInfoFacadeService = commodityInfoFacadeService;
        this.adverProperties = adverProperties;
        this.okHttpService = okHttpService;
    }

    private List<AdvertDto> getByPosition(Integer position) {
        return this.loadFromDb(position);
    }

    private List<AdvertDto> loadFromDb(Integer position) {
        List<Object> advertDtoList = Lists.newArrayList();
        List advertEntries = this.advertMapper.listByPositionType(position);
        if (advertEntries.size() > 0) {
            List relationIds = advertEntries.stream().map(AdvertEntry::getRelationId).collect(Collectors.toList());
            List relationInfos = this.advertMapper.listByRelationId(relationIds);
            advertEntries.forEach(advert -> relationInfos.forEach(relation -> {
                if (Objects.equals(advert.getRelationId(), relation.getRelationId()) && advert.getMaterialId() == null) {
                    BeanUtils.copyProperties((Object)relation, (Object)advert);
                }
            }));
            advertDtoList = advertEntries.stream().map(this::convert).filter(advert -> advert.getMaterialId() != null).collect(Collectors.toList());
        }
        return advertDtoList;
    }

    private List<AdvertDto> loadCache(Integer position) {
        List advertDtos;
        if (null == this.postionCache) {
            this.postionCache = CacheBuilder.newBuilder().expireAfterWrite(this.adverProperties.getMemoryCacheExpireMinute().longValue(), TimeUnit.MINUTES).maximumSize(2000L).build((CacheLoader)new CacheLoader<Integer, List<AdvertDto>>(){

                public List<AdvertDto> load(Integer key) {
                    return AdvertServiceImpl.this.getByPosition(key);
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)(advertDtos = (List)this.postionCache.getUnchecked((Object)position)))) {
            return Lists.newArrayList();
        }
        return advertDtos.stream().map(p -> {
            AdvertDto advertDto = new AdvertDto();
            BeanUtils.copyProperties((Object)p, (Object)advertDto);
            return advertDto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<AdvertDto> list(AdvertParam param) {
        List<AdvertDto> advertDtos = this.filter(this.loadCache(param.getPosition()), param);
        if (!CollectionUtils.isEmpty(advertDtos)) {
            this.attach(param, advertDtos);
        }
        return advertDtos;
    }

    @Override
    public List<AdvertDto> getRelationDetail(AdvertRelationParam param) {
        if (null == this.detailCache) {
            this.detailCache = CacheBuilder.newBuilder().expireAfterWrite(this.adverProperties.getMemoryCacheExpireMinute().longValue(), TimeUnit.MINUTES).maximumSize(1000L).build((CacheLoader)new CacheLoader<Long, List<AdvertDto>>(){

                public List<AdvertDto> load(Long key) {
                    return AdvertServiceImpl.this.advertMapper.listByRelationId((List)ImmutableList.of((Object)key)).stream().map(item -> AdvertServiceImpl.this.convert(item)).collect(Collectors.toList());
                }
            });
        }
        return (List)this.detailCache.getUnchecked((Object)param.getRelationId());
    }

    @Override
    public List<ClassificationDTO> listVipClassification(UserIdParam userIdParam) {
        AdvertParam advertParam = new AdvertParam();
        BeanUtils.copyProperties((Object)userIdParam, (Object)advertParam);
        List classificationDTOList = JSONObject.parseArray((String)this.adverProperties.getClassification(), ClassificationDTO.class);
        return classificationDTOList.stream().map(e -> {
            advertParam.setPosition(e.getId());
            ClassificationDTO classificationDTO = new ClassificationDTO();
            BeanUtils.copyProperties((Object)e, (Object)classificationDTO);
            List<AdvertDto> advertDtoList = this.list(advertParam);
            classificationDTO.setAdvertDtoList(advertDtoList);
            return classificationDTO;
        }).collect(Collectors.toList());
    }

    private void attach(AdvertParam param, List<AdvertDto> advertDtos) {
        String tbkRelationId = this.userInfoService.getTbkRelationId(param.getUserId());
        advertDtos.forEach(p -> {
            if (Objects.nonNull(p) && StringUtils.isNotBlank((String)tbkRelationId) && StringUtils.isNotBlank((String)p.getAdzoneId()) && StringUtils.isNotBlank((String)p.getPromotionSceneId())) {
                Long adzoneId = null;
                Long promotionSceneId = null;
                try {
                    adzoneId = Long.valueOf(p.getAdzoneId());
                    promotionSceneId = Long.parseLong(p.getPromotionSceneId());
                }
                catch (Exception e) {
                    log.warn("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff0cmaterialId: {} \u7684\u5e7f\u544a\u4f4d\u914d\u7f6e\u6709\u95ee\u9898", (Object)p.getMaterialId());
                }
                if (Objects.nonNull(adzoneId) && Objects.nonNull(promotionSceneId)) {
                    String taoBaoUnionUrl = this.getTaoBaoUnionUrl(adzoneId, promotionSceneId, tbkRelationId);
                    if (taoBaoUnionUrl.contains("https")) {
                        p.setUrl(StringUtils.isNotBlank((String)taoBaoUnionUrl) ? taoBaoUnionUrl.replaceAll("https", "qtj://profession/openApp?url=tbopen") : "");
                    } else {
                        p.setUrl(StringUtils.isNotBlank((String)taoBaoUnionUrl) ? taoBaoUnionUrl.replaceAll("http", "qtj://profession/openApp?url=tbopen") : "");
                    }
                }
            }
        });
    }

    private List<AdvertDto> filter(List<AdvertDto> advertDtoList, AdvertParam param) {
        if (CollectionUtils.isEmpty(advertDtoList)) {
            return Lists.newArrayList();
        }
        this.advertisementFilterChainService.filter(advertDtoList, param);
        List<AdvertDto> list = this.doResult(advertDtoList, param);
        if (!CollectionUtils.isEmpty(list)) {
            this.handlePreconditions(list, param);
        }
        if (param.getPosition() == 2 && 15 < advertDtoList.size()) {
            int redundant = advertDtoList.size() % 15;
            for (int i = 0; i < redundant; ++i) {
                advertDtoList.remove(advertDtoList.size() - 1);
            }
        }
        return list;
    }

    private void listForPlatform(List<AdvertDto> listSource, AdvertParam param) {
        if (param.getPlatform() == PlatformEnum.ANDROID.getCode()) {
            listSource.removeIf(advertDto -> advertDto.getPlatform().intValue() == PlatformEnum.ANDROID.getCode());
        }
        if (param.getPlatform() == PlatformEnum.IOS.getCode()) {
            listSource.removeIf(advertDto -> advertDto.getPlatform().intValue() == PlatformEnum.IOS.getCode());
        }
    }

    private List<AdvertDto> doResult(List<AdvertDto> listSource, AdvertParam param) {
        this.listForPlatform(listSource, param);
        AdvertPositionEnum advertPosition = AdvertPositionEnum.getByPosition((int)param.getPosition());
        if (advertPosition == null) {
            return listSource;
        }
        switch (advertPosition) {
            case TJG_BANNER: {
                if (!this.externalAdvertConfig.isExternalTjgFlag()) {
                    log.info("\u5173\u95ed\u6dd8\u91d1\u8c37");
                    return null;
                }
                String tjgTotalUrl = this.externalAdvertConfig.getTjgTotalUrl();
                listSource.forEach(advertDto -> advertDto.setTotalUrl(tjgTotalUrl));
                break;
            }
            case SWLH_BANNER: {
                String androidImei = this.getAndroidImei(param.getDevcId());
                if (!this.externalAdvertConfig.isExternalSwlhFlag() || androidImei == null) {
                    log.info("\u5173\u95ed\u8bd5\u73a9\u96f6\u82b1bannel");
                    return null;
                }
                UserInfoDto userInfo = this.userInfoService.getUserById(param.getUserId());
                if (userInfo == null) {
                    return null;
                }
                String swlhTotalUrl = this.externalAdvertConfig.getSwlhTotalUrl().replace("{channel}", this.externalAdvertConfig.getChannel()).replace("{uid}", userInfo.getId().toString()).replace("{nickname}", userInfo.getNickName()).replace("{imei}", androidImei).replace("{headImgUrl}", userInfo.getHeadImg());
                listSource.forEach(advertDto -> advertDto.setTotalUrl(swlhTotalUrl));
                break;
            }
            case SWLH_APP_LIST: {
                String androidImei13 = this.getAndroidImei(param.getDevcId());
                if (!this.externalAdvertConfig.isExternalSwlhFlag() || androidImei13 == null) {
                    log.info("\u5173\u95ed\u8bd5\u73a9\u96f6\u82b1app\u5217\u8868");
                    return null;
                }
                listSource = this.getSwlhList(androidImei13, param.getUserId());
                break;
            }
        }
        return listSource;
    }

    private void handlePreconditions(List<AdvertDto> list, AdvertParam param) {
        AppChannelVersionVO appChannelVersionVO = this.appVersionFacadeService.getNewversion(new AppVersionParam(param.getPlatform(), param.getChnl()));
        boolean canUpdate = null != appChannelVersionVO && Objects.nonNull(appChannelVersionVO.getVersion()) && com.bxm.newidea.component.tools.StringUtils.compareVersion((String)param.getCurVer(), (String)appChannelVersionVO.getVersion()) < 0;
        this.handlePrecondition(list, param, appChannelVersionVO, canUpdate);
        list.forEach(p -> {
            if (!CollectionUtils.isEmpty((Collection)p.getPreconditions())) {
                p.setPreconditions(p.getPreconditions().stream().peek(p1 -> {
                    if (AdvertPrecondition.HAS_HIGHER_VERSION.getCode() == p1.intValue() && canUpdate) {
                        p.setDownloadUrl(appChannelVersionVO.getDownloadLink());
                    }
                }).map(AdvertPrecondition::getByCode).filter(Objects::nonNull).sorted(Comparator.comparingInt(AdvertPrecondition::getOrder)).map(AdvertPrecondition::getCode).collect(Collectors.toList()));
            } else if (Objects.nonNull(p.getPrecondition()) && p.getPrecondition() != 0) {
                p.setPreconditions(Collections.singletonList(p.getPrecondition()));
            }
        });
    }

    private void handlePrecondition(List<AdvertDto> list, AdvertParam param, AppChannelVersionVO appChannelVersionVO, boolean canUpdate) {
        boolean hasBindtaobao = this.userInfoFacadeService.hasBindTaobao(param.getUserId());
        for (AdvertDto advertDto : list) {
            if (!CollectionUtils.isEmpty((Collection)advertDto.getPreconditions()) && canUpdate) {
                advertDto.setPrecondition(Integer.valueOf(AdvertPrecondition.HAS_HIGHER_VERSION.getCode()));
                advertDto.setDownloadUrl(appChannelVersionVO != null ? appChannelVersionVO.getDownloadLink() : null);
                continue;
            }
            if (null != advertDto.getPrecondition()) {
                if (advertDto.getPrecondition().intValue() == AdvertPrecondition.HAS_HIGHER_VERSION.getCode()) {
                    if (null != appChannelVersionVO && Objects.nonNull(appChannelVersionVO.getVersion()) && com.bxm.newidea.component.tools.StringUtils.compareVersion((String)param.getCurVer(), (String)appChannelVersionVO.getVersion()) < 0) {
                        advertDto.setPrecondition(Integer.valueOf(AdvertPrecondition.HAS_HIGHER_VERSION.getCode()));
                        advertDto.setDownloadUrl(appChannelVersionVO.getDownloadLink());
                        continue;
                    }
                } else if (advertDto.getPrecondition().intValue() == AdvertPrecondition.BIND_TAOBAO.getCode()) {
                    advertDto.setPrecondition(Integer.valueOf(hasBindtaobao ? 0 : 1));
                    continue;
                }
            }
            advertDto.setPrecondition(Integer.valueOf(0));
        }
    }

    private List<AdvertDto> getSwlhList(String imei, Long userId) {
        List<AdvertDto> list;
        KeyGenerator wellChoseKey = ActivityRedisKeyConstant.ADVERD_SWLH_APP_INFO.copy();
        String swlhInfoByKey = this.redisStringAdapter.getString(wellChoseKey);
        if (StringUtils.isNotBlank((String)swlhInfoByKey)) {
            list = JSONArray.parseArray((String)swlhInfoByKey, AdvertDto.class);
        } else {
            list = this.convert(imei, userId);
            if (list.size() > 0) {
                this.redisStringAdapter.set(wellChoseKey, (Object)JSON.toJSONString(list), 300L);
            }
        }
        return list;
    }

    private List<AdvertDto> convert(String imei, Long userId) {
        ArrayList<AdvertDto> resultList = new ArrayList<AdvertDto>();
        String resultStr = null;
        try {
            resultStr = this.okHttpService.get(this.externalAdvertConfig.getSwlhApiUrl().replace("{imei}", imei).replace("{uid}", userId.toString()), (Map)Maps.newHashMap());
        }
        catch (Exception e) {
            log.error("\u8bd5\u73a9\u96f6\u82b1\u4ea4\u4e92\u5f02\u5e38  \uff1a {}", (Throwable)e);
        }
        UserInfoDto userInfo = this.userInfoService.getUserById(userId);
        if (StringUtils.isNotBlank(resultStr) && resultStr.startsWith("[{") && userInfo != null) {
            List swlhList = JSONArray.parseArray((String)resultStr, AppInfoForSwlh.class);
            for (AppInfoForSwlh appInfoForSwlh : swlhList) {
                AdvertDto advertDto = new AdvertDto();
                this.convert(advertDto, appInfoForSwlh, userInfo, imei);
                resultList.add(advertDto);
            }
        }
        return resultList;
    }

    private void convert(AdvertDto advertDto, AppInfoForSwlh appInfoForSwlh, UserInfoDto userInfo, String imei) {
        String totalUrl = this.externalAdvertConfig.getSwlhTotalUrl().replace("{channel}", this.externalAdvertConfig.getChannel()).replace("{uid}", userInfo.getId().toString()).replace("{nickname}", userInfo.getNickName()).replace("{imei}", imei).replace("{headImgUrl}", userInfo.getHeadImg());
        advertDto.setTitle(appInfoForSwlh.getAdname());
        advertDto.setSubTitle(appInfoForSwlh.getIntro());
        advertDto.setShowmoney(appInfoForSwlh.getShowmoney());
        advertDto.setImgUrl(appInfoForSwlh.getImgurl());
        advertDto.setUrl(totalUrl);
        advertDto.setTotalUrl(totalUrl);
    }

    private AdvertDto convert(AdvertEntry advertEntry) {
        AdvertDto advertDto = new AdvertDto();
        BeanUtils.copyProperties((Object)advertEntry, (Object)advertDto);
        advertDto.setPromotionSceneId(advertEntry.getUrl());
        List<Object> preconditions = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)advertEntry.getPreconditions())) {
            preconditions = Arrays.stream(advertEntry.getPreconditions().split(",")).map(Integer::parseInt).collect(Collectors.toList());
        }
        advertDto.setPreconditions((List)preconditions);
        return advertDto;
    }

    private String getAndroidImei(String deviceId) {
        EquipmentDTO equipmentDTO = this.equipmentFacadeService.getByDeviceId(deviceId);
        if (equipmentDTO == null) {
            return null;
        }
        if (equipmentDTO.getImei() != null) {
            return equipmentDTO.getImei();
        }
        if (equipmentDTO.getAndroidId() != null) {
            return equipmentDTO.getAndroidId();
        }
        if (equipmentDTO.getAndroidUuid() != null) {
            return equipmentDTO.getAndroidUuid();
        }
        return null;
    }

    private String getTaoBaoUnionUrl(Long adzoneId, Long promotionSceneId, String relationId) {
        TbkActivitylinkGetRequest req = new TbkActivitylinkGetRequest();
        req.setAdzoneId(adzoneId);
        req.setRelationId(relationId);
        req.setPromotionSceneId(promotionSceneId);
        TbkActivitylinkGetResponse taoBaoUnion = this.commodityInfoFacadeService.getTaoBaoUnion(adzoneId, relationId, promotionSceneId);
        if (Objects.nonNull(taoBaoUnion) && StringUtils.isNotBlank((String)taoBaoUnion.getData())) {
            return taoBaoUnion.getData().replaceAll("\\\\", "");
        }
        return "";
    }
}

