/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.advert.impl;

import com.alibaba.fastjson.JSONArray;
import com.bxm.fossicker.activity.config.AdvertConfig;
import com.bxm.fossicker.activity.enums.AdvertSceneEnum;
import com.bxm.fossicker.activity.model.dto.AdvertSceneDTO;
import com.bxm.fossicker.activity.model.dto.AdvertStrategyConfigDTO;
import com.bxm.fossicker.activity.model.dto.AdvertStrategyDTO;
import com.bxm.fossicker.activity.model.param.AdvertSceneParam;
import com.bxm.fossicker.activity.model.vo.AdvertSceneInfo;
import com.bxm.fossicker.activity.service.advert.AdvertStrategyService;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.vo.BasicParam;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AdvertStrategyServiceImpl
implements AdvertStrategyService {
    private final ActivityProperties activityProperties;
    @Autowired
    private AdvertConfig advertConfig;
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    private Map<String, List<AdvertStrategyDTO>> cacheMap;
    private long lastParseTime;
    private List<AdvertStrategyDTO> defaultMatch;
    private static final long PARSE_INTERVAL = 300000L;
    private static final String DEFAULT_STRATEGY_NAME = "default";

    @Autowired
    public AdvertStrategyServiceImpl(ActivityProperties activityProperties) {
        this.activityProperties = activityProperties;
    }

    @Override
    public List<AdvertStrategyDTO> getAdvertStrategy(BasicParam basicParam) {
        List<AdvertStrategyDTO> matchRes;
        if (System.currentTimeMillis() - this.lastParseTime > 300000L) {
            this.parse();
        }
        if (null == (matchRes = this.cacheMap.get(basicParam.getCurVer()))) {
            matchRes = this.defaultMatch;
        }
        return matchRes;
    }

    @Override
    public AdvertSceneDTO getAdvertForScene(AdvertSceneParam param) {
        String sceneInfoStr = (String)this.advertConfig.getSceneKeys().get(AdvertSceneEnum.getSceneCode((int)param.getPosition()));
        if (StringUtils.isBlank((CharSequence)sceneInfoStr)) {
            return null;
        }
        List sceneInfoList = JSONArray.parseArray((String)sceneInfoStr, AdvertSceneInfo.class);
        if (CollectionUtils.isEmpty((Collection)sceneInfoList)) {
            return null;
        }
        boolean isNoviceUser = this.userInfoFacadeService.isNoviceUser(param.getUserId());
        AdvertSceneDTO advertSceneDTO = new AdvertSceneDTO();
        for (AdvertSceneInfo advertSceneInfo : sceneInfoList) {
            if (!isNoviceUser) {
                if (advertSceneInfo.getIsNoviceUser() != 0 || param.getPlatform() != advertSceneInfo.getPlatform()) continue;
                BeanUtils.copyProperties((Object)advertSceneInfo, (Object)advertSceneDTO);
                break;
            }
            if (advertSceneInfo.getIsNoviceUser() != 1 || param.getPlatform() != advertSceneInfo.getPlatform()) continue;
            BeanUtils.copyProperties((Object)advertSceneInfo, (Object)advertSceneDTO);
        }
        return advertSceneDTO;
    }

    private void parse() {
        List advertStrategyConfigList;
        int configSize;
        String config = this.activityProperties.getAdvertStrategyConfigList();
        this.defaultMatch = null;
        this.cacheMap = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)config) && (configSize = (advertStrategyConfigList = JSONArray.parseArray((String)config, AdvertStrategyConfigDTO.class)).size()) > 0) {
            advertStrategyConfigList.forEach(strategy -> this.cacheMap.put(strategy.getVersion(), strategy.getConfig()));
            this.defaultMatch = this.cacheMap.containsKey(DEFAULT_STRATEGY_NAME) ? this.cacheMap.get(DEFAULT_STRATEGY_NAME) : ((AdvertStrategyConfigDTO)advertStrategyConfigList.get(configSize - 1)).getConfig();
        }
        this.lastParseTime = System.currentTimeMillis();
    }
}

