/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.clock.impl;

import com.bxm.fossicker.activity.facade.TelephoneChargeFacadeService;
import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.model.dto.ClockInfoDTO;
import com.bxm.fossicker.activity.model.param.ClockActivityParam;
import com.bxm.fossicker.activity.model.param.ClockOperateParam;
import com.bxm.fossicker.activity.model.vo.ClockInfo;
import com.bxm.fossicker.activity.service.clock.ClockActivityService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClockActivityServiceImpl
implements ClockActivityService {
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private TelephoneChargeFacadeService telephoneChargeFacadeService;
    private static Integer CLOCK_OVER_DAYS = 7;

    @Override
    public ClockInfoDTO getClockInfo(ClockActivityParam param) {
        ClockInfo clockInfo = this.getClockInfoFromRedis(param.getUserId());
        if (Objects.isNull(clockInfo)) {
            return ClockInfoDTO.builder().clockToday(Integer.valueOf(0)).clockLastDays(Integer.valueOf(0)).buttonStatus(Integer.valueOf(1)).build();
        }
        int days = this.differentDays(new Date(), clockInfo.getClockLastTime());
        if (days >= 2) {
            return ClockInfoDTO.builder().clockToday(Integer.valueOf(0)).clockLastDays(Integer.valueOf(0)).buttonStatus(Integer.valueOf(1)).build();
        }
        if (days == 0) {
            return ClockInfoDTO.builder().clockToday(Integer.valueOf(1)).clockLastDays(clockInfo.getClockLastDays()).buttonStatus(Integer.valueOf(Objects.equals(clockInfo.getClockLastDays(), CLOCK_OVER_DAYS) ? 3 : 2)).build();
        }
        if (clockInfo.getClockLastDays() >= CLOCK_OVER_DAYS) {
            return ClockInfoDTO.builder().clockToday(Integer.valueOf(0)).clockLastDays(clockInfo.getClockLastDays()).buttonStatus(Integer.valueOf(3)).build();
        }
        return ClockInfoDTO.builder().clockToday(Integer.valueOf(0)).clockLastDays(clockInfo.getClockLastDays()).buttonStatus(Integer.valueOf(1)).build();
    }

    @Override
    public ClockInfoDTO clockOperateCallBack(ClockOperateParam param) {
        ClockInfo clockInfo = this.getClockInfoFromRedis(param.getUserId());
        if (Objects.isNull(clockInfo)) {
            this.redisHashMapAdapter.put(this.getClockInfoKey(), param.getUserId().toString(), (Object)ClockInfo.builder().clockLastDays(Integer.valueOf(1)).clockLastTime(new Date()).build());
            return this.getClockInfo((ClockActivityParam)param);
        }
        int days = this.differentDays(new Date(), clockInfo.getClockLastTime());
        if (days >= 2) {
            this.redisHashMapAdapter.put(this.getClockInfoKey(), param.getUserId().toString(), (Object)ClockInfo.builder().clockLastDays(Integer.valueOf(1)).clockLastTime(new Date()).build());
            return this.getClockInfo((ClockActivityParam)param);
        }
        if (DateUtils.isSameDay((Date)new Date(), (Date)clockInfo.getClockLastTime())) {
            return this.getClockInfo((ClockActivityParam)param);
        }
        this.redisHashMapAdapter.put(this.getClockInfoKey(), param.getUserId().toString(), (Object)ClockInfo.builder().clockLastDays(Integer.valueOf(clockInfo.getClockLastDays() + 1)).clockLastTime(new Date()).build());
        if (clockInfo.getClockLastDays() + 1 == CLOCK_OVER_DAYS) {
            this.telephoneChargeFacadeService.addTelephoneChargeList(param.getUserId(), Byte.valueOf((byte)3));
            this.redisHashMapAdapter.put(this.getHasOverClockUserKey(), param.getUserId().toString(), (Object)System.currentTimeMillis());
        }
        return this.getClockInfo((ClockActivityParam)param);
    }

    private ClockInfo getClockInfoFromRedis(Long userId) {
        ClockInfo clockInfo = (ClockInfo)this.redisHashMapAdapter.get(this.getClockInfoKey(), userId.toString(), ClockInfo.class);
        if (Objects.isNull(clockInfo)) {
            return null;
        }
        return clockInfo;
    }

    private KeyGenerator getClockInfoKey() {
        return ActivityRedisKey.CLOCK_ACTIVITY_INFO_KEY.copy();
    }

    private KeyGenerator getHasOverClockUserKey() {
        return ActivityRedisKey.CLOCK_ACTIVITY_INFO_HAS_OVER_KEY.copy();
    }

    private int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return Math.abs(day2 - day1);
    }
}

