/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.debris.cache;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.constants.DebrisActivityAwardType;
import com.bxm.fossicker.activity.model.dto.debris.DebrisGrantRuleDTO;
import com.bxm.fossicker.activity.service.config.ActivityDebrisProperties;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.RandomUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GrantDebrisCacheManager {
    private static final Logger log = LoggerFactory.getLogger(GrantDebrisCacheManager.class);
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final ActivityDebrisProperties activityDebrisProperties;

    public boolean hasGrantDebris(Integer type, Integer targetDebrisNum, Integer hasWatchNum) {
        int targetWatchNum = this.getTargetWatchNum(type, targetDebrisNum);
        log.info("\u7c7b\u578b\uff1a{}, \u76ee\u6807\u788e\u7247\u6570\uff1a{}, \u5f53\u524d\u5df2\u770b\u89c6\u9891\u6570\uff1a{}, \u76ee\u6807\u89c6\u9891\u4e2a\u6570\uff1a{}", new Object[]{type, targetDebrisNum, hasWatchNum, targetWatchNum});
        if (targetWatchNum <= 0) {
            return false;
        }
        return hasWatchNum >= targetWatchNum;
    }

    public void remove(Integer type) {
        this.redisHashMapAdapter.remove(this.buildGrantNumCache(type));
    }

    private int getTargetWatchNum(Integer type, Integer targetNum) {
        Integer watchNum;
        if (!this.redisHashMapAdapter.hasKey(this.buildGrantNumCache(type)).booleanValue()) {
            this.initGrantDebrisRule(type);
        }
        return Objects.isNull(watchNum = (Integer)this.redisHashMapAdapter.get(this.buildGrantNumCache(type), String.valueOf(targetNum), Integer.class)) ? -1 : watchNum;
    }

    private void initGrantDebrisRule(Integer type) {
        KeyGenerator grantNumCacheKey = this.buildGrantNumCache(type);
        String debrisRule = Objects.equals(type, DebrisActivityAwardType.CHARGE.getCode()) ? this.activityDebrisProperties.getChargeDebrisRule() : this.activityDebrisProperties.getVirtualDebrisRule();
        List<DebrisGrantRuleDTO> ruleList = this.getDebrisRule(debrisRule);
        int targetDebrisCounter = 0;
        for (DebrisGrantRuleDTO ruleItem : ruleList) {
            this.redisHashMapAdapter.put(grantNumCacheKey, ruleItem.getKey(), (Object)(targetDebrisCounter += RandomUtils.nextInt((int)ruleItem.getValue().getLeft(), (int)(ruleItem.getValue().getRight() + 1))));
        }
    }

    private List<DebrisGrantRuleDTO> getDebrisRule(String debrisRule) {
        return JSON.parseArray((String)debrisRule, DebrisGrantRuleDTO.class);
    }

    private KeyGenerator buildGrantNumCache(Integer type) {
        return ActivityRedisKeyConstant.GRANT_DEBRIS_RULE_KEY.copy().appendKey((Object)type);
    }

    public GrantDebrisCacheManager(RedisHashMapAdapter redisHashMapAdapter, ActivityDebrisProperties activityDebrisProperties) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.activityDebrisProperties = activityDebrisProperties;
    }
}

