/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.debris.cache;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.text.DateFormat;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserLotteryCacheManager {
    private static final Logger log = LoggerFactory.getLogger(UserLotteryCacheManager.class);
    private final RedisStringAdapter redisStringAdapter;
    public static final Long EXPIRED_TIME = 86400L;

    public void incrementUserLotteryNum(Long userId) {
        String currentDateStr = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
        if (Boolean.FALSE.equals(this.redisStringAdapter.hasKey(this.buildUserLotteryNumCache(userId, currentDateStr)))) {
            this.redisStringAdapter.increment(this.buildUserLotteryNumCache(userId, currentDateStr), EXPIRED_TIME.longValue());
        } else {
            this.redisStringAdapter.increment(this.buildUserLotteryNumCache(userId, currentDateStr));
        }
    }

    public Integer getUserLotteryNum(Long userId) {
        String currentDateStr = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
        Integer currentLotteryNum = (Integer)this.redisStringAdapter.get(this.buildUserLotteryNumCache(userId, currentDateStr), Integer.class);
        return Objects.isNull(currentLotteryNum) ? 0 : currentLotteryNum;
    }

    private KeyGenerator buildUserLotteryNumCache(Long userId, String dateStr) {
        return ActivityRedisKeyConstant.USER_DEBRIS_LOTTERY_NUM.copy().appendKey((Object)userId).appendKey((Object)dateStr);
    }

    public UserLotteryCacheManager(RedisStringAdapter redisStringAdapter) {
        this.redisStringAdapter = redisStringAdapter;
    }
}

