/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.debris.cache;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserTotalLotteryCacheManager {
    private static final Logger log = LoggerFactory.getLogger(UserTotalLotteryCacheManager.class);
    private final RedisStringAdapter redisStringAdapter;

    public void incrementUserLotteryNum(Long userId) {
        this.redisStringAdapter.increment(this.buildUserLotteryNumCache(userId));
    }

    public Integer getUserLotteryNum(Long userId) {
        Integer currentLotteryNum = (Integer)this.redisStringAdapter.get(this.buildUserLotteryNumCache(userId), Integer.class);
        return Objects.isNull(currentLotteryNum) ? 0 : currentLotteryNum;
    }

    private KeyGenerator buildUserLotteryNumCache(Long userId) {
        return ActivityRedisKeyConstant.USER_TOTAL_DEBRIS_LOTTERY_NUM.copy().appendKey((Object)userId);
    }

    public UserTotalLotteryCacheManager(RedisStringAdapter redisStringAdapter) {
        this.redisStringAdapter = redisStringAdapter;
    }
}

